/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class ChainedLogger
implements Logger,
Externalizable {
    private static final Logger LOG = Logging.getLoggerInstance(ChainedLogger.class);
    private final List<Logger> loggers = new CopyOnWriteArrayList<Logger>();

    public ChainedLogger() {
    }

    public ChainedLogger(Logger ... ls) {
        for (Logger l : ls) {
            this.addLogger(l);
        }
    }

    public List<Logger> getLoggers() {
        return Collections.unmodifiableList(this.loggers);
    }

    public ChainedLogger addLogger(Logger l) {
        this.loggers.add(l);
        return this;
    }

    public boolean containsLogger(Logger l) {
        return this.loggers.contains(l);
    }

    public boolean removeLogger(Logger l) {
        return this.loggers.remove(l);
    }

    @Override
    public void trace(Object m) {
        for (Logger log : this.loggers) {
            log.trace(m);
        }
    }

    @Override
    public void trace(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.trace(m, t);
        }
    }

    @Override
    public void debug(Object m) {
        for (Logger log : this.loggers) {
            log.debug(m);
        }
    }

    @Override
    public void debug(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.debug(m, t);
        }
    }

    @Override
    public void service(Object m) {
        for (Logger log : this.loggers) {
            log.service(m);
        }
    }

    @Override
    public void service(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.service(m, t);
        }
    }

    @Override
    public void info(Object m) {
        for (Logger log : this.loggers) {
            log.info(m);
        }
    }

    @Override
    public void info(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.info(m, t);
        }
    }

    @Override
    public void warn(Object m) {
        for (Logger log : this.loggers) {
            log.warn(m);
        }
    }

    @Override
    public void warn(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.warn(m, t);
        }
    }

    @Override
    public void error(Object m) {
        for (Logger log : this.loggers) {
            log.error(m);
        }
    }

    @Override
    public void error(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.error(m, t);
        }
    }

    @Override
    public void fatal(Object m) {
        for (Logger log : this.loggers) {
            log.fatal(m);
        }
    }

    @Override
    public void fatal(Object m, Throwable t) {
        for (Logger log : this.loggers) {
            log.fatal(m, t);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        for (Logger log : this.loggers) {
            if (!log.isTraceEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDebugEnabled() {
        for (Logger log : this.loggers) {
            if (!log.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isServiceEnabled() {
        for (Logger log : this.loggers) {
            if (!log.isServiceEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabledFor(Level l) {
        for (Logger log : this.loggers) {
            if (!log.isEnabledFor(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLevel(Level p) {
        for (Logger log : this.loggers) {
            log.setLevel(p);
        }
    }

    public String toString() {
        return "" + this.loggers;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        List serializableLoggers = (List)in.readObject();
        this.loggers.addAll(serializableLoggers);
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        ArrayList<Logger> serializableLoggers = new ArrayList<Logger>();
        for (Logger l : this.loggers) {
            if (l instanceof Serializable) {
                serializableLoggers.add(l);
                continue;
            }
            LOG.warn(" " + l + " is not serializable");
        }
        stream.writeObject(serializableLoggers);
    }
}

