/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptErrorReporter
implements ErrorReporter {
    private final Logger log;

    public JavaScriptErrorReporter(Logger log) {
        this.log = log == null ? Logging.getLoggerInstance("org.mmbase.JAVASCRIPT") : log;
    }

    public JavaScriptErrorReporter() {
        this(null);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.log.warn(sourceName + " " + message);
        } else {
            this.log.warn(sourceName + " " + line + ':' + lineOffset + ':' + message);
        }
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.log.error(sourceName + " " + message);
        } else {
            this.log.error(sourceName + " " + line + ':' + lineOffset + ':' + message);
        }
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }
}

