/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.io.IOException;
import java.io.Writer;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class LoggerWriter
extends Writer {
    private static final Logger LOG = Logging.getLoggerInstance(LoggerWriter.class);
    protected final Logger logger;
    private final StringBuilder buffer = new StringBuilder();
    private final Level level;
    protected String prefix = "";
    private long count = 0L;

    public LoggerWriter(Logger log, Level lev) {
        this.logger = log;
        this.level = lev;
    }

    public LoggerWriter(Logger log, Level lev, String p) {
        this(log, lev);
        this.prefix = p;
    }

    protected Level getLevel(String line) {
        return this.level;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected void logLine(String line) {
        Level l = this.getLevel(line);
        if (l == null) {
            l = this.level;
        }
        Logging.log(l, this.logger, this.getPrefix() + line);
        ++this.count;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(char[] buf, int start, int end) throws IOException {
        this.buffer.append(buf, start, end);
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        String[] lines = this.buffer.toString().split("[\\n\\r]");
        int used = 0;
        for (int i = 0; i < lines.length - 1; ++i) {
            this.logLine(lines[i]);
            used += lines[i].length();
            ++used;
        }
        this.buffer.delete(0, used);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.buffer.length() > 0) {
            this.logLine(this.buffer.toString());
        }
    }
}

