/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.mmbase.core.event.EventManager;
import org.mmbase.util.ApplicationContextReader;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.LoggerWrapper;
import org.mmbase.util.logging.MDC;
import org.mmbase.util.logging.SimpleImpl;
import org.mmbase.util.logging.SimpleTimeStampImpl;
import org.mmbase.util.xml.DocumentReader;

public class Logging {
    private static Class<?> logClass = SimpleTimeStampImpl.class;
    private static boolean configured = false;
    private static final Logger log = Logging.getLoggerInstance(Logging.class);
    public static final String PAGE_CATEGORY = "org.mmbase.PAGE";
    private static ResourceLoader resourceLoader;
    private static ThreadLocal<Map<String, Object>> MDC_MAP;
    private static MDC mdc;

    private Logging() {
    }

    public static String getMachineName() {
        return EventManager.getMachineName();
    }

    public static Map<String, String> getInitParameters() {
        try {
            return ApplicationContextReader.getProperties("mmbase-logging");
        }
        catch (NamingException ne) {
            log.debug("Can't obtain properties from application context: " + ne.getMessage());
            return new HashMap<String, String>();
        }
    }

    public static void configure(ResourceLoader rl, String configFile) {
        DocumentReader reader;
        resourceLoader = rl;
        ResourceWatcher configWatcher = new ResourceWatcher(rl){

            @Override
            public void onChange(String s) {
                Logging.configure(this.resourceLoader, s);
            }
        };
        if (configFile == null) {
            log.info("No configfile given, default configuration will be used.");
            return;
        }
        log.debug("Configuring logging with " + configFile + " (" + resourceLoader.getResource(configFile) + ")");
        configWatcher.add(configFile);
        configWatcher.setDelay(10000L);
        configWatcher.start();
        try {
            reader = new DocumentReader(resourceLoader.getInputSource(configFile), Logging.class);
        }
        catch (Exception e) {
            log.error("Could not open " + configFile + " " + e, e);
            return;
        }
        if (reader == null) {
            log.error("No " + configFile);
            return;
        }
        String classToUse = SimpleTimeStampImpl.class.getName();
        String configuration = "stderr,info";
        Map<String, String> overrides = Logging.getInitParameters();
        try {
            String config;
            String claz;
            String string = claz = overrides.containsKey("class") ? overrides.get("class") : reader.getElementValue("logging.class");
            if (claz != null) {
                classToUse = claz;
            }
            String string2 = config = overrides.containsKey("configuration") ? overrides.get("configuration") : reader.getElementValue("logging.configuration");
            if (config != null) {
                configuration = config;
            }
        }
        catch (Exception e) {
            log.error("Exception during parsing: " + e.getMessage(), e);
        }
        log.info("Logging: " + classToUse + " (" + configuration + ").  Configured in " + resourceLoader.getResource(configFile));
        Class<?> logClassCopy = logClass;
        try {
            logClass = Class.forName(classToUse);
            if (configured && !logClassCopy.equals(logClass)) {
                log.warn("Tried to change logging implementation from " + logClassCopy + " to " + logClass + ". This is not really possible (most static instances are unreachable). Trying anyway as requested, if this gives strange results, you might need to restart.");
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find class " + classToUse);
            log.error(e.toString());
            logClass = logClassCopy;
        }
        catch (Throwable e) {
            log.error("Exception to find class " + classToUse + ": " + e);
            log.info("Falling back to " + logClassCopy.getName());
            logClass = logClassCopy;
        }
        Logging.configureClass(configuration);
        configured = true;
        log.service("Logging configured");
        log.debug("Now watching " + configWatcher.getResources());
        log.debug("Replacing wrappers " + LoggerWrapper.getWrappers());
        for (LoggerWrapper wrapper : LoggerWrapper.getWrappers()) {
            wrapper.setLogger(Logging.getLoggerInstance(wrapper.getName()));
            log.debug("Replaced logger " + wrapper.getName());
        }
        mdc = null;
        ResourceLoader.initLogging();
    }

    public static void configureClass(String configuration) {
        try {
            Method conf = logClass.getMethod("configure", String.class);
            conf.invoke(null, configuration);
        }
        catch (NoSuchMethodException e) {
            log.debug("Could not find configure method in " + logClass.getName());
        }
        catch (InvocationTargetException e) {
            log.error("Invocation Exception while configuration class. " + logClass + " with configuration String '" + configuration + "' :" + e.getMessage(), e);
        }
        catch (Exception e) {
            log.error("", e);
        }
    }

    public static ResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public static Logger getLoggerInstance(String s) {
        try {
            Method getIns = logClass.getMethod("getLoggerInstance", String.class);
            Logger logger = (Logger)getIns.invoke(null, s);
            if (configured) {
                return logger;
            }
            return new LoggerWrapper(logger, s);
        }
        catch (Exception e) {
            log.warn(e);
            return SimpleImpl.getLoggerInstance(s);
        }
    }

    public static MDC getMDC() {
        if (mdc == null) {
            try {
                Method getIns = logClass.getMethod("getMDC", new Class[0]);
                mdc = (MDC)getIns.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                log.warn(e);
                mdc = new MDC(){

                    @Override
                    public void put(String key, Object value) {
                        if (value != null) {
                            ((Map)MDC_MAP.get()).put(key, value);
                        } else {
                            ((Map)MDC_MAP.get()).remove(key);
                        }
                    }

                    @Override
                    public Object get(String key) {
                        return ((Map)MDC_MAP.get()).get(key);
                    }
                };
            }
            log.service("Found MDC " + mdc);
        }
        return mdc;
    }

    public static Logger getLoggerInstance(Class<?> cl) {
        return Logging.getLoggerInstance(cl.getName());
    }

    public static void shutdown() {
        try {
            if (configured) {
                for (LoggerWrapper wrapper : LoggerWrapper.getWrappers()) {
                    wrapper.setLogger(SimpleImpl.getLoggerInstance(wrapper.getName() + ".SHUTDOWN"));
                }
                if (logClass != null) {
                    Method shutdown = logClass.getMethod("shutdown", new Class[0]);
                    shutdown.invoke(null, new Object[0]);
                }
                mdc = null;
                configured = false;
            }
        }
        catch (NoSuchMethodException shutdown) {
        }
        catch (Throwable e) {
            System.err.println(e + Logging.stackTrace(e));
        }
    }

    public static String stackTrace() {
        return Logging.stackTrace(-1);
    }

    public static String stackTrace(int max) {
        Exception e = new Exception("logging.stacktrace");
        return Logging.stackTrace(e, max);
    }

    public static String stackTrace(Throwable e) {
        return Logging.stackTrace(e, -1);
    }

    public static String stackTrace(Throwable e, int max) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        String message = e.getMessage();
        StringBuilder buf = new StringBuilder(e.getClass().getName());
        buf.append(": ");
        if (message != null) {
            buf.append(message);
        }
        for (int i = 0; i < stackTrace.length && i != max; ++i) {
            buf.append("\n        at ").append(stackTrace[i]);
        }
        Throwable t = e.getCause();
        if (t != null) {
            buf.append("\n").append(Logging.stackTrace(t, max));
        }
        return buf.toString();
    }

    public static String applicationStacktrace() {
        Exception e = new Exception("logging.showApplicationStacktrace");
        return Logging.applicationStacktrace(e);
    }

    public static String applicationStacktrace(Throwable e) {
        StringBuilder buf = new StringBuilder("Application stacktrace");
        StackTraceElement[] stackTrace = e.getStackTrace();
        boolean mmbaseClassesFound = false;
        int appended = 0;
        for (StackTraceElement element : stackTrace) {
            String className = element.getClassName();
            if (className.indexOf("org.mmbase") > -1) {
                mmbaseClassesFound = true;
                if (className.indexOf("bridge.jsp.taglib") <= -1) continue;
                buf.append("\n        at ").append(element);
                ++appended;
                continue;
            }
            if (mmbaseClassesFound) {
                buf.append("\n        at ").append(element);
                ++appended;
                break;
            }
            if (className.indexOf("_jsp") <= -1) continue;
            buf.append("\n        at ").append(element);
            ++appended;
        }
        if (appended == 0) {
            for (int i = 2; i < stackTrace.length; ++i) {
                buf.append("\n        at ").append(stackTrace[i]);
            }
        }
        return buf.toString();
    }

    public static void log(Level l, Logger log, String mes) {
        switch (l.toInt()) {
            case 5000: {
                log.trace(mes);
                break;
            }
            case 10000: {
                log.debug(mes);
                break;
            }
            case 15000: {
                log.service(mes);
                break;
            }
            case 20000: {
                log.info(mes);
                break;
            }
            case 30000: {
                log.warn(mes);
                break;
            }
            case 40000: {
                log.error(mes);
                break;
            }
            case 50000: {
                log.fatal(mes);
                break;
            }
            case 0x7FFFFFFF: {
                break;
            }
        }
    }

    public static boolean isEnabled(Level l, Logger log) {
        switch (l.toInt()) {
            case 5000: {
                return log.isTraceEnabled();
            }
            case 10000: {
                return log.isDebugEnabled();
            }
            case 15000: {
                return log.isServiceEnabled();
            }
            case 0x7FFFFFFF: {
                return false;
            }
        }
        return true;
    }

    static {
        MDC_MAP = new ThreadLocal<Map<String, Object>>(){

            @Override
            protected Map<String, Object> initialValue() {
                return new HashMap<String, Object>();
            }
        };
        mdc = null;
    }
}

