/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mmbase.util.logging.AbstractSimpleImpl;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class SimpleTimeStampImpl
extends AbstractSimpleImpl
implements Logger {
    private Map<Level, PrintStream> ps = new HashMap<Level, PrintStream>();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS ");
    private static final Map<String, SimpleTimeStampImpl> loggers = new ConcurrentHashMap<String, SimpleTimeStampImpl>();
    private static final SimpleTimeStampImpl root = new SimpleTimeStampImpl("");
    private static List<Map.Entry<String, String>> configurations;
    private final String name;

    public static SimpleTimeStampImpl getLoggerInstance(String name) {
        SimpleTimeStampImpl impl = loggers.get(name);
        if (impl == null) {
            impl = new SimpleTimeStampImpl(name);
            impl.level = SimpleTimeStampImpl.root.level;
            loggers.put(name, impl);
            for (Map.Entry<String, String> conf : configurations) {
                if (!name.startsWith(conf.getKey())) continue;
                impl.conf(conf.getValue());
            }
        }
        return impl;
    }

    private SimpleTimeStampImpl(String n) {
        for (Level l : Level.getLevels()) {
            if (l.toInt() >= Level.WARN.toInt()) {
                this.ps.put(l, System.err);
                continue;
            }
            this.ps.put(l, System.out);
        }
        this.name = n;
    }

    protected PrintStream getStream(Level l) {
        return this.ps.get(l);
    }

    public static void configure(String c) {
        for (String line : c.trim().split("\\s+")) {
            if (line.startsWith("#")) continue;
            String[] e = line.trim().split(":", 2);
            if (e.length == 2) {
                SimpleTimeStampImpl.configure(e[0].trim(), e[1].trim());
                continue;
            }
            SimpleTimeStampImpl.configure("", e[0].trim());
        }
    }

    private void conf(String c) {
        StringTokenizer t = new StringTokenizer(c, ",");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if ("stderr".equals(token)) {
                for (Level l : Level.getLevels()) {
                    this.ps.put(l, System.err);
                }
                continue;
            }
            if ("stdout".equals(token)) {
                for (Level l : Level.getLevels()) {
                    this.ps.put(l, System.out);
                }
                continue;
            }
            if ("trace".equals(token)) {
                this.setLevel(Level.TRACE);
                continue;
            }
            if ("debug".equals(token)) {
                this.setLevel(Level.DEBUG);
                continue;
            }
            if ("service".equals(token)) {
                this.setLevel(Level.SERVICE);
                continue;
            }
            if ("info".equals(token)) {
                this.setLevel(Level.INFO);
                continue;
            }
            if ("warn".equals(token)) {
                this.setLevel(Level.WARN);
                continue;
            }
            if ("error".equals(token)) {
                this.setLevel(Level.ERROR);
                continue;
            }
            if (!"fatal".equals(token)) continue;
            this.setLevel(Level.FATAL);
        }
    }

    public static void configure(String prefix, String c) {
        if (c == null) {
            return;
        }
        configurations.add(new AbstractMap.SimpleEntry<String, String>(prefix, c));
        for (Map.Entry<String, SimpleTimeStampImpl> entry : loggers.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            SimpleTimeStampImpl logger = entry.getValue();
            logger.conf(c);
        }
    }

    @Override
    protected final void log(String s, Level l) {
        PrintStream stream = this.getStream(l);
        stream.println(l.toString() + " " + dateFormat.format(new Date()) + s);
        int stacktraceLevel = 50000;
        if (l.toInt() >= stacktraceLevel) {
            Throwable t = new Throwable();
            stream.println(Logging.stackTrace(t));
        }
    }

    public String toString() {
        return this.name + ":" + this.level;
    }

    static {
        loggers.put("", root);
        configurations = new CopyOnWriteArrayList<Map.Entry<String, String>>();
    }
}

