/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging.commons.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.logging.commons.impl.MMBaseLogger;

public class MMBaseLoggingFactory
extends LogFactory {
    private Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    private Map<Object, Log> instances = Collections.synchronizedMap(new HashMap());

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.attributes.keySet());
        String[] results = new String[names.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String)names.get(i);
        }
        return results;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        Log instance = this.instances.get(clazz);
        if (instance != null) {
            return instance;
        }
        instance = new MMBaseLogger(Logging.getLoggerInstance(clazz));
        this.instances.put(clazz, instance);
        return instance;
    }

    public Log getInstance(String category) throws LogConfigurationException {
        Log instance = this.instances.get(category);
        if (instance != null) {
            return instance;
        }
        instance = new MMBaseLogger(Logging.getLoggerInstance(category));
        this.instances.put(category, instance);
        return instance;
    }

    public void release() {
        this.instances.clear();
        Logging.shutdown();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }
}

