/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging.log4j;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;
import org.mmbase.util.logging.Logging;

public class MMPatternParser
extends PatternParser {
    public MMPatternParser(String pattern) {
        super(pattern);
    }

    public void finalizeConverter(char c) {
        if (c == 'q') {
            this.addConverter(new TruncatedLevelPatternConverter(this.formattingInfo));
            this.currentLiteral.setLength(0);
        } else if (c == 'k') {
            this.addConverter(new MemoryPatternConverter(this.formattingInfo));
            this.currentLiteral.setLength(0);
        } else if (c == 'N') {
            this.addConverter(new MachineNamePatternConverter(this.formattingInfo));
            this.currentLiteral.setLength(0);
        } else if (c == 'T') {
            this.addConverter(new ThreadGroupPatternConverter(this.formattingInfo));
            this.currentLiteral.setLength(0);
        } else {
            super.finalizeConverter(c);
        }
    }

    private static class ThreadGroupPatternConverter
    extends PatternConverter {
        ThreadGroupPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            return String.format("{0}", Thread.currentThread().getThreadGroup().getName());
        }
    }

    private static class MachineNamePatternConverter
    extends PatternConverter {
        MachineNamePatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            return String.format("{0}", Logging.getMachineName());
        }
    }

    private static class MemoryPatternConverter
    extends PatternConverter {
        MemoryPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            Runtime rt = Runtime.getRuntime();
            return "" + (rt.totalMemory() - rt.freeMemory()) / 1024L;
        }
    }

    private static class TruncatedLevelPatternConverter
    extends PatternConverter {
        TruncatedLevelPatternConverter(FormattingInfo formattingInfo) {
            super(formattingInfo);
        }

        public String convert(LoggingEvent event) {
            return event.getLevel().toString().substring(0, 3);
        }
    }
}

