/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.BasicDetector;
import org.mmbase.util.magicfile.Detector;
import org.mmbase.util.magicfile.DetectorProvider;

public class MagicParser
implements DetectorProvider {
    public static final String DEFAULT_MAGIC_FILE = "/etc/mime-magic";
    private static final Logger log = Logging.getLoggerInstance(MagicParser.class);
    private final List<Detector> detectors = new ArrayList<Detector>();
    private int offset;
    private String type;
    private String test;
    private String message;
    private char testComparator;

    public MagicParser() {
        this(DEFAULT_MAGIC_FILE);
    }

    public MagicParser(String fileName) {
        log.info("creating a new MagicParser with configuration/etc/mime-magic");
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));
            while ((line = br.readLine()) != null) {
                Detector d = this.createDetector(line);
                if (d == null) continue;
                this.detectors.add(d);
            }
        }
        catch (Exception e) {
            log.error("" + e.getMessage() + "}", e);
        }
    }

    @Override
    public List<Detector> getDetectors() {
        return this.detectors;
    }

    protected int nextWhiteSpace(String s) {
        return this.nextWhiteSpace(s, 0);
    }

    protected int nextWhiteSpace(String s, int startIndex) {
        for (int j = startIndex; j < s.length(); ++j) {
            if (s.charAt(j) != ' ' && s.charAt(j) != '\t' && s.charAt(j) != '\n') continue;
            return j;
        }
        return s.length();
    }

    protected int nextNonWhiteSpace(String s, int startIndex) {
        for (int j = startIndex; j < s.length(); ++j) {
            if (s.charAt(j) == ' ' || s.charAt(j) == '\t') continue;
            return j;
        }
        return -1;
    }

    private int parseOffsetString(String s, int startIndex) throws Exception {
        try {
            int m = this.nextWhiteSpace(s, startIndex);
            char c = s.charAt(startIndex);
            if (c == '&') {
                throw new UnsupportedOperationException("parseOffsetString: >& offset feature not implemented\n(Tt is used only for HP Printer Job Language type)");
            }
            if (c == '(') {
                throw new UnsupportedOperationException("parseOffsetString: indirect offsets not implemented");
            }
            this.offset = Integer.decode(s.substring(startIndex, m));
            return this.nextNonWhiteSpace(s, m + 1);
        }
        catch (NumberFormatException e) {
            throw new Exception("parseOffetString: string->integer conversion failure for '" + s + "'");
        }
    }

    private int parseTypeString(String s, int startIndex) throws Exception {
        int m = this.nextWhiteSpace(s, startIndex);
        if (m <= startIndex) {
            throw new Exception("parseTypeString: failed to delimit type string");
        }
        int n = s.indexOf(38, startIndex);
        this.type = n > -1 && n < m - 2 ? s.substring(startIndex, n) : s.substring(startIndex, m);
        return this.nextNonWhiteSpace(s, m + 1);
    }

    private int parseTestString(String s, int startIndex) throws Exception {
        int i;
        int start = 0;
        boolean backslashmode = false;
        boolean octalmode = false;
        boolean hexmode = false;
        StringBuilder numbuf = new StringBuilder();
        this.test = "";
        char c = s.charAt(startIndex);
        switch (c) {
            case '&': 
            case '<': 
            case '=': 
            case '>': 
            case '^': {
                this.testComparator = c;
                start = 1;
                break;
            }
            default: {
                this.testComparator = (char)61;
            }
        }
        if (s.charAt(startIndex + start) == '~' || s.charAt(startIndex + start) == '!') {
            ++start;
        }
        if (!"string".equals(this.type)) {
            int m = this.nextWhiteSpace(s, i);
            String t = s.substring(i, m);
            if ("x".equals(t)) {
                this.test = "x";
            } else {
                if ("beshort".equals(this.type) || "leshort".equals(this.type)) {
                    try {
                        this.test = "0x" + Integer.toHexString(Integer.decode(s.substring(i, m)));
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("decode(" + s.substring(i, m) + ")");
                    }
                }
                if ("belong".equals(this.test) || "lelong".equals(this.test)) {
                    int endIndex = m;
                    try {
                        if (s.charAt(m - 1) == 'L' || s.charAt(m - 1) == 'l') {
                            endIndex = m - 1;
                        }
                        this.test = "0x" + Long.toHexString(Long.decode(s.substring(i, endIndex)));
                    }
                    catch (NumberFormatException e) {
                        log.error(e.getMessage());
                        log.error(Logging.stackTrace(e));
                        throw new Exception("parseLong(" + s.substring(i, endIndex) + ") ");
                    }
                }
                if ("byte".equals(this.type)) {
                    try {
                        this.test = "0x" + Integer.toHexString(Integer.decode(s.substring(i, m)));
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("decode(" + s.substring(i, m) + ")");
                    }
                }
            }
            i = m;
        } else {
            StringBuilder buf = new StringBuilder();
            int m = s.length();
            block36: for (i = startIndex + start; i < m; ++i) {
                c = s.charAt(i);
                if (backslashmode) {
                    switch (c) {
                        case 'n': {
                            backslashmode = false;
                            buf.append('\n');
                            break;
                        }
                        case 'r': {
                            backslashmode = false;
                            buf.append('\r');
                            break;
                        }
                        case 't': {
                            backslashmode = false;
                            buf.append('\t');
                            break;
                        }
                        case '\\': {
                            if (hexmode) {
                                try {
                                    this.test = this.test + (char)Integer.decode("0x" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0x" + numbuf.toString() + ") faalde");
                                }
                                hexmode = false;
                                break;
                            }
                            if (octalmode) {
                                try {
                                    this.test = this.test + (char)Integer.decode("0" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0" + numbuf.toString() + ") faalde");
                                }
                                octalmode = false;
                                break;
                            }
                            backslashmode = false;
                            buf.append('\\');
                            break;
                        }
                        case 'x': {
                            if (octalmode && numbuf.length() == 3) {
                                try {
                                    this.test = this.test + (char)Integer.decode("0" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0" + numbuf.toString() + ") faalde");
                                }
                                octalmode = false;
                                backslashmode = false;
                                buf = new StringBuilder();
                                buf.append('x');
                                break;
                            }
                            hexmode = true;
                            numbuf = new StringBuilder();
                            if (buf.length() <= 0) continue block36;
                            this.test = this.test + buf.toString();
                            buf = new StringBuilder();
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (!octalmode && !hexmode) {
                                if (buf.length() > 0) {
                                    this.test = this.test + buf.toString();
                                    buf = new StringBuilder();
                                }
                                octalmode = true;
                                numbuf = new StringBuilder();
                            }
                            numbuf.append(c);
                            break;
                        }
                        case ' ': {
                            if (octalmode) {
                                try {
                                    this.test = this.test + (char)Integer.decode("0" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0" + numbuf.toString() + ") faalde");
                                }
                                octalmode = false;
                            } else if (hexmode) {
                                try {
                                    this.test = this.test + (char)Integer.decode("0x" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0x" + numbuf.toString() + ") faalde");
                                }
                                hexmode = false;
                            } else {
                                buf.append(' ');
                            }
                            backslashmode = false;
                            break;
                        }
                        default: {
                            if (hexmode) {
                                if (c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F') {
                                    numbuf.append(c);
                                    break;
                                }
                                try {
                                    this.test = this.test + (char)Integer.decode("0x" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0x" + numbuf.toString() + ") faalde");
                                }
                                hexmode = false;
                                backslashmode = false;
                                break;
                            }
                            if (octalmode) {
                                try {
                                    this.test = this.test + (char)Integer.decode("0" + numbuf.toString()).intValue();
                                }
                                catch (NumberFormatException e) {
                                    throw new Exception("decode(0" + numbuf.toString() + ") faalde");
                                }
                                octalmode = false;
                                backslashmode = false;
                                break;
                            }
                            backslashmode = false;
                            buf.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    if (buf.length() > 0) {
                        this.test = this.test + buf.toString();
                        buf = new StringBuilder();
                    }
                    backslashmode = true;
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\n' || i == m - 1) {
                    if (buf.length() > 0) {
                        this.test = this.test + buf.toString();
                        buf = new StringBuilder();
                    }
                    if (numbuf.length() <= 0) break;
                    if (octalmode) {
                        try {
                            this.test = this.test + (char)Integer.decode("0" + numbuf.toString()).intValue();
                        }
                        catch (NumberFormatException e) {
                            throw new Exception("decode(0" + numbuf.toString() + ") faalde");
                        }
                        octalmode = false;
                        backslashmode = false;
                        break;
                    }
                    if (!hexmode) break;
                    try {
                        this.test = this.test + (char)Integer.decode("0x" + numbuf.toString()).intValue();
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("decode(0x" + numbuf.toString() + ") faalde");
                    }
                    hexmode = false;
                    backslashmode = false;
                    break;
                }
                buf.append(c);
            }
        }
        return this.nextNonWhiteSpace(s, i + 1);
    }

    private int parseMessageString(String s, int startIndex) throws Exception {
        this.message = s.substring(startIndex);
        return s.length() - 1;
    }

    private Detector createDetector(String line) {
        BasicDetector detector = new BasicDetector();
        log.debug("parse: " + line);
        try {
            int n = this.parseOffsetString(line, 0);
            n = this.parseTypeString(line, n);
            n = this.parseTestString(line, n);
            if (n > 0) {
                this.parseMessageString(line, n);
            } else {
                this.message = "";
            }
        }
        catch (UnsupportedOperationException e) {
            log.warn(e.getMessage());
        }
        catch (Exception e) {
            log.error("parse failure: " + e.getMessage() + " for [" + line + "]", e);
        }
        detector.setType(this.type);
        detector.setOffset("" + this.offset);
        detector.setTest(this.test);
        detector.setComparator(this.testComparator);
        detector.setMimeType(this.message);
        detector.setDesignation(this.message);
        return detector;
    }

    public boolean toXML(String path) throws IOException {
        File f = new File(path);
        return this.toXML(f);
    }

    public boolean toXML(File f) throws IOException {
        FileWriter writer = new FileWriter(f);
        writer.write("<!DOCTYPE magic PUBLIC \"-//MMBase//DTD magic config 1.0//EN\" \"http://www.mmbase.org/dtd/magic_1_0.dtd\">\n<magic>\n<info>\n<version>0.1</version>\n<author>cjr@dds.nl</author>\n<description>Conversion of the UNIX 'magic' file with added mime types and extensions.</description>\n</info>\n<detectorlist>\n");
        for (Detector detector : this.getDetectors()) {
            if (!(detector instanceof BasicDetector)) continue;
            ((BasicDetector)detector).toXML(writer);
        }
        writer.write("</detectorlist>\n</magic>\n");
        writer.close();
        return true;
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.err.println(MagicParser.class.getName() + " can be used to convert from mime files to mmbase magic.xml file format");
            System.err.println("Usage:" + MagicParser.class.getName() + " inpurtFileName outputfile.xml");
            System.err.println("Example:" + MagicParser.class.getName() + " /etc/mime-magic outputfile.xml");
            System.exit(1);
        }
        System.out.println("reading the mime file");
        MagicParser parser = new MagicParser(argv[0]);
        System.out.println("writing the xml file");
        parser.toXML(new File(argv[1]));
        System.out.println("finished");
    }
}

