/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.magicfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.AbstractDetector;

public class ZipDetector
extends AbstractDetector {
    private static final Logger LOG = Logging.getLoggerInstance(ZipDetector.class);
    protected final List<Pattern> files = new ArrayList<Pattern>();
    protected final List<Pattern> directories = new ArrayList<Pattern>();

    public void setHasFiles(String hasFiles) {
        for (String f : hasFiles.split(",")) {
            this.files.add(Pattern.compile(f));
        }
    }

    public void setHasDirectories(String hasDirectories) {
        for (String d : hasDirectories.split(",")) {
            this.directories.add(Pattern.compile(d));
        }
    }

    @Override
    public boolean test(byte[] lithmus, InputStream input) {
        return this.test(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean test(InputStream input) {
        try {
            ZipEntry ze;
            HashMap<Pattern, Boolean> matchedFiles = new HashMap<Pattern, Boolean>();
            for (Pattern pattern : this.files) {
                matchedFiles.put(pattern, false);
            }
            HashMap<Pattern, Boolean> matchedDirectories = new HashMap<Pattern, Boolean>();
            for (Pattern p : this.directories) {
                matchedDirectories.put(p, false);
            }
            ZipInputStream zipInputStream = new ZipInputStream(input);
            while ((ze = zipInputStream.getNextEntry()) != null) {
                String name = ze.getName();
                for (Map.Entry entry : matchedFiles.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue() || !((Pattern)entry.getKey()).matcher(name).matches()) continue;
                    LOG.debug("Matched " + entry.getKey() + " on" + ze);
                    entry.setValue(true);
                }
                int dirIndex = name.lastIndexOf("/");
                if (dirIndex <= 0) continue;
                String string = name.substring(0, dirIndex);
                for (Map.Entry entry : matchedDirectories.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue() || !((Pattern)entry.getKey()).matcher(string).matches()) continue;
                    LOG.debug("Matched " + entry.getKey() + " on " + string);
                    entry.setValue(true);
                }
            }
            boolean result = true;
            Iterator iterator = matchedFiles.values().iterator();
            while (iterator.hasNext()) {
                boolean bl = (Boolean)iterator.next();
                result &= bl;
            }
            iterator = matchedDirectories.values().iterator();
            while (iterator.hasNext()) {
                boolean bl = (Boolean)iterator.next();
                result &= bl;
            }
            boolean bl = result;
            return bl;
        }
        catch (IOException ioe) {
            LOG.warn(ioe);
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public String toString() {
        return "files:" + this.files + " directories:" + this.directories;
    }
}

