/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public abstract class BufferedReaderTransformer
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(BufferedReaderTransformer.class);

    @Override
    public final Writer transform(Reader r, Writer w) {
        try {
            BufferedReader br = new BufferedReader(r);
            PrintWriter bw = new PrintWriter(new BufferedWriter(w));
            Status status = this.createNewStatus();
            String line = br.readLine();
            while (line != null) {
                boolean nl = this.transform(bw, line, status);
                line = br.readLine();
                if (!nl || line == null) continue;
                bw.write(10);
            }
            br.close();
            bw.flush();
        }
        catch (IOException e) {
            log.error(e.toString(), e);
        }
        return w;
    }

    protected abstract boolean transform(PrintWriter var1, String var2, Status var3);

    protected abstract Status createNewStatus();

    protected static abstract class Status {
        protected Status() {
        }
    }
}

