/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.mmbase.util.IOUtil;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ByteToCharTransformer;

public abstract class ByteArrayToCharTransformer
implements ByteToCharTransformer {
    private static final Logger log = Logging.getLoggerInstance(ByteArrayToCharTransformer.class);

    @Override
    public abstract String transform(byte[] var1);

    @Override
    public final OutputStream transformBack(Reader r) {
        return this.transformBack(r, new ByteArrayOutputStream());
    }

    @Override
    public final Writer transform(InputStream in) {
        return this.transform(in, new StringWriter());
    }

    @Override
    public byte[] transformBack(String r) {
        throw new UnsupportedOperationException("transformBack is not supported for this transformer");
    }

    @Override
    public Writer transform(InputStream in, Writer w) {
        try {
            ByteArrayOutputStream sw = new ByteArrayOutputStream();
            IOUtil.copy(in, sw);
            String result = this.transform(sw.toByteArray());
            w.write(result);
        }
        catch (IOException e) {
            log.error(e.toString(), e);
        }
        return w;
    }

    @Override
    public OutputStream transformBack(Reader in, OutputStream out) {
        try {
            StringWriter sw = new StringWriter();
            IOUtil.copy(in, sw);
            out.write(this.transformBack(sw.toString()));
        }
        catch (IOException e) {
            log.error(e.toString(), e);
        }
        return out;
    }
}

