/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ByteTransformer;

public class ByteTransformerLink
implements Runnable {
    private static final Logger log = Logging.getLoggerInstance(ByteTransformerLink.class);
    private ByteTransformer transformer;
    private OutputStream out;
    private InputStream in;
    private boolean closeOutputStream;
    private boolean ready = false;
    private Throwable exception;

    public ByteTransformerLink(ByteTransformer t, InputStream i, OutputStream o, boolean co) {
        this.in = i;
        this.out = o;
        this.transformer = t;
        this.closeOutputStream = co;
    }

    @Override
    public synchronized void run() {
        block5: {
            try {
                this.transformer.transform(this.in, this.out);
            }
            catch (Throwable t) {
                log.error(t.toString(), t);
                this.exception = t;
            }
            if (this.closeOutputStream) {
                try {
                    this.out.close();
                }
                catch (IOException io) {
                    log.error(io.toString(), io);
                    if (this.exception == null) break block5;
                    this.exception = io;
                }
            }
        }
        this.ready = true;
        this.notifyAll();
    }

    public synchronized boolean ready() {
        return this.ready;
    }

    public Throwable getException() {
        return this.exception;
    }
}

