/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableReaderTransformer;
import org.mmbase.util.transformers.UnicodeEscaper;
import org.mmbase.util.transformers.UnknownCodingException;

public class CP1252Surrogator
extends ConfigurableReaderTransformer
implements CharTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logging.getLoggerInstance(CP1252Surrogator.class);
    public static final int WELL_ENCODED = 0;
    public static final int WRONG_ENCODED = 1;

    public CP1252Surrogator() {
        this(0);
    }

    public CP1252Surrogator(int conf) {
        super(conf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            block36: while (true) {
                int c;
                if ((c = r.read()) == -1) {
                    return w;
                }
                int cp = this.to == 0 ? ("" + (char)c).getBytes("CP1252")[0] & 0xFF : c;
                switch (cp) {
                    case 128: {
                        w.write("EURO");
                        continue block36;
                    }
                    case 129: {
                        w.write(63);
                        continue block36;
                    }
                    case 130: {
                        w.write(44);
                        continue block36;
                    }
                    case 131: {
                        w.write(102);
                        continue block36;
                    }
                    case 132: {
                        w.write(",,");
                        continue block36;
                    }
                    case 133: {
                        w.write("...");
                        continue block36;
                    }
                    case 134: {
                        w.write(43);
                        continue block36;
                    }
                    case 135: {
                        w.write("++");
                        continue block36;
                    }
                    case 136: {
                        w.write(94);
                        continue block36;
                    }
                    case 137: {
                        w.write("0/00");
                        continue block36;
                    }
                    case 138: {
                        w.write(83);
                        continue block36;
                    }
                    case 139: {
                        w.write(60);
                        continue block36;
                    }
                    case 140: {
                        w.write("OE");
                        continue block36;
                    }
                    case 141: {
                        w.write(63);
                        continue block36;
                    }
                    case 142: {
                        w.write(90);
                        continue block36;
                    }
                    case 143: {
                        w.write(63);
                        continue block36;
                    }
                    case 144: {
                        w.write(63);
                        continue block36;
                    }
                    case 145: {
                        w.write(39);
                        continue block36;
                    }
                    case 146: {
                        w.write(39);
                        continue block36;
                    }
                    case 147: {
                        w.write(34);
                        continue block36;
                    }
                    case 148: {
                        w.write(34);
                        continue block36;
                    }
                    case 149: {
                        w.write(45);
                        continue block36;
                    }
                    case 150: {
                        w.write(45);
                        continue block36;
                    }
                    case 151: {
                        w.write(45);
                        continue block36;
                    }
                    case 152: {
                        w.write(126);
                        continue block36;
                    }
                    case 153: {
                        w.write("(TM)");
                        continue block36;
                    }
                    case 154: {
                        w.write(115);
                        continue block36;
                    }
                    case 155: {
                        w.write(62);
                        continue block36;
                    }
                    case 156: {
                        w.write("oe");
                        continue block36;
                    }
                    case 157: {
                        w.write(63);
                        continue block36;
                    }
                    case 158: {
                        w.write(122);
                        continue block36;
                    }
                    case 159: {
                        w.write(89);
                        continue block36;
                    }
                }
                w.write(c);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put("CP1252_SURROGATOR", new Config(CP1252Surrogator.class, 0, "Takes the java String, and surrogates the 32 characters of it which are in CP1252 but not in ISO-8859-1"));
        h.put("CP1252_WRONG_SURROGATOR", new Config(CP1252Surrogator.class, 1, "Also surrogates the characters specific to CP1252, but supposed the String originally wrong encoded (it was suppoed to be ISO-8859-1, but actually was CP1252)"));
        return h;
    }

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 0: {
                return "CP1252_SURROGATOR";
            }
            case 1: {
                return "CP1252_WRONG_SURROGATOR";
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    public static byte[] getTestBytes() {
        byte[] testBytes = new byte[32];
        for (int i = 0; i < 32; ++i) {
            testBytes[i] = (byte)(-128 + i);
        }
        return testBytes;
    }

    public static String getTestString() {
        try {
            return new String(CP1252Surrogator.getTestBytes(), "CP1252");
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public static void main(String[] args) {
        String testStringCP1252 = "bla bla " + CP1252Surrogator.getTestString();
        String testStringISO1 = "";
        try {
            testStringISO1 = "bla bla " + new String(CP1252Surrogator.getTestBytes(), "ISO-8859-1");
        }
        catch (Exception e) {
            log.error("", e);
        }
        CP1252Surrogator transOk = new CP1252Surrogator();
        CP1252Surrogator transNok = new CP1252Surrogator(1);
        UnicodeEscaper unicode = new UnicodeEscaper();
        System.out.println("Test-string (CP1252): " + testStringCP1252);
        System.out.println("Java-escaped (CP1252): " + unicode.transform(testStringCP1252));
        System.out.println("Java-escaped (ISO-1) : " + unicode.transform(testStringISO1));
        System.out.println("Surrogated test-string (CP1252): " + transOk.transform(testStringCP1252));
        System.out.println("Surrogated test-string (ISO-1) : " + transNok.transform(testStringISO1));
    }
}

