/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.CharTransformerLink;
import org.mmbase.util.transformers.ReaderTransformer;
import org.mmbase.util.transformers.SpaceReducer;
import org.mmbase.util.transformers.Trimmer;
import org.mmbase.util.transformers.UnicodeEscaper;
import org.mmbase.util.transformers.UpperCaser;

public class ChainedCharTransformer
extends ReaderTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logging.getLoggerInstance(ChainedCharTransformer.class);
    private List<CharTransformer> charTransformers = new ArrayList<CharTransformer>();

    public ChainedCharTransformer add(CharTransformer ct) {
        if (ct instanceof ChainedCharTransformer) {
            this.addAll(((ChainedCharTransformer)ct).charTransformers);
        } else {
            this.charTransformers.add(ct);
        }
        return this;
    }

    public ChainedCharTransformer addAll(Collection<CharTransformer> col) {
        for (CharTransformer c : col) {
            this.add(c);
        }
        return this;
    }

    public ChainedCharTransformer add(CharTransformer ... col) {
        for (CharTransformer c : col) {
            this.add(c);
        }
        return this;
    }

    @Override
    public String transform(String string) {
        for (CharTransformer ct : this.charTransformers) {
            string = ct.transform(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer transform(Reader startReader, Writer endWriter) {
        try {
            PipedReader r = null;
            Writer w = endWriter;
            boolean closeWriterAfterUse = false;
            ArrayList<CharTransformerLink> links = new ArrayList<CharTransformerLink>();
            ListIterator<CharTransformer> i = this.charTransformers.listIterator(this.charTransformers.size());
            while (i.hasPrevious()) {
                CharTransformer ct = i.previous();
                if (i.hasPrevious()) {
                    r = new PipedReader();
                    CharTransformerLink link = new CharTransformerLink(ct, r, w, closeWriterAfterUse);
                    links.add(link);
                    w = new PipedWriter(r);
                    closeWriterAfterUse = true;
                    ThreadPools.filterExecutor.execute(link);
                    continue;
                }
                ct.transform(startReader, w);
                if (!closeWriterAfterUse) continue;
                w.close();
            }
            for (CharTransformerLink l : links) {
                try {
                    while (!l.ready()) {
                        CharTransformerLink charTransformerLink = l;
                        synchronized (charTransformerLink) {
                            l.wait();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    log.warn("" + ie);
                }
            }
            for (CharTransformerLink l : links) {
                Throwable t = l.getException();
                if (t == null) continue;
                if (t instanceof RuntimeException) {
                    log.info("Trowing runtime exception from " + l);
                    throw new RuntimeException(t);
                }
                log.error(t.getMessage(), t);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
            log.info(Logging.stackTrace(e));
        }
        return endWriter;
    }

    @Override
    public String toString() {
        return "CHAINED" + this.charTransformers;
    }

    public static void main(String[] args) throws IOException {
        ChainedCharTransformer t = new ChainedCharTransformer().add((CharTransformer)new UnicodeEscaper()).add((CharTransformer)new SpaceReducer()).add((CharTransformer)new UpperCaser()).add((CharTransformer)new Trimmer());
        System.out.println("Starting transform");
        t.transform(new InputStreamReader(System.in), new OutputStreamWriter(System.out)).flush();
        System.out.println(t.transform("test test   test test "));
        System.out.println("Finished transform");
    }
}

