/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;

public class CharTransformerLink
implements Runnable {
    private static final Logger log = Logging.getLoggerInstance(CharTransformerLink.class);
    private CharTransformer charTransformer;
    private Writer writer;
    private Reader reader;
    private boolean closeWriter;
    private boolean ready = false;
    private Throwable exception;

    public CharTransformerLink(CharTransformer ct, Reader r, Writer w, boolean cw) {
        this.reader = r;
        this.writer = w;
        this.charTransformer = ct;
        this.closeWriter = cw;
    }

    @Override
    public synchronized void run() {
        try {
            this.charTransformer.transform(this.reader, this.writer);
        }
        catch (Throwable t) {
            this.exception = t;
        }
        finally {
            if (this.closeWriter) {
                try {
                    this.writer.close();
                }
                catch (IOException io) {
                    log.error(io.getMessage(), io);
                }
            }
            this.ready = true;
            this.notifyAll();
        }
    }

    public synchronized boolean ready() {
        return this.ready;
    }

    public Throwable getException() {
        return this.exception;
    }
}

