/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableReaderTransformer;
import org.mmbase.util.transformers.Sql;

public class Javascript
extends ConfigurableReaderTransformer
implements CharTransformer {
    private static final long serialVersionUID = 0L;
    private static final String SINGLE_QUOTES = "JAVASCRIPT_ESCAPE_SINGLE_QUOTES";
    private static final String DOUBLE_QUOTES = "JAVASCRIPT_ESCAPE_DOUBLE_QUOTES";
    private static final String BOTH_QUOTES = "JAVASCRIPT_ESCAPE_BOTH_QUOTES";
    public static final int ESCAPE_SINGLE_QUOTES = 1;
    public static final int ESCAPE_DOUBLE_QUOTES = 2;
    public static final int ESCAPE_BOTH_QUOTES = 3;

    public Javascript() {
        super(1);
    }

    public Javascript(int conf) {
        super(conf);
    }

    public static Writer escapeChar(Reader r, Writer w, char escapeChar) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == escapeChar) {
                    w.write(92);
                }
                if (c == 92) {
                    w.write(92);
                }
                if (c == 10) {
                    w.write("\\n");
                    continue;
                }
                if (c == 13) continue;
                w.write(c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w;
    }

    public static Writer escapeChar(Reader r, Writer w) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == 39 || c == 34) {
                    w.write(92);
                }
                if (c == 92) {
                    w.write(92);
                }
                if (c == 10) {
                    w.write("\\n");
                    continue;
                }
                if (c == 13) continue;
                w.write(c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w;
    }

    public static Writer escapeCharBack(Reader r, Writer w) {
        try {
            int c;
            boolean skipNext = false;
            while ((c = r.read()) != -1) {
                if (c == 39) {
                    if (skipNext) {
                        skipNext = false;
                        continue;
                    }
                    w.write(c);
                    skipNext = true;
                    continue;
                }
                w.write(c);
                skipNext = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w;
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put(SINGLE_QUOTES, new Config(Sql.class, 1, "Escape single quotes for Javascript statements"));
        h.put(DOUBLE_QUOTES, new Config(Sql.class, 2, "Escape single quotes for Javascript statements"));
        h.put(BOTH_QUOTES, new Config(Sql.class, 3, "Escape single and double quotes for Javascript statements"));
        return h;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        switch (this.to) {
            case 1: {
                return Javascript.escapeChar(r, w, '\'');
            }
            case 2: {
                return Javascript.escapeChar(r, w, '\"');
            }
            case 3: {
                return Javascript.escapeChar(r, w);
            }
        }
        throw new UnsupportedOperationException("Cannot transform");
    }

    @Override
    public Writer transformBack(Reader r, Writer w) {
        switch (this.to) {
            case 1: 
            case 2: 
            case 3: {
                return Javascript.escapeCharBack(r, w);
            }
        }
        throw new UnsupportedOperationException("Cannot transform");
    }

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 1: {
                return SINGLE_QUOTES;
            }
            case 2: {
                return DOUBLE_QUOTES;
            }
            case 3: {
                return BOTH_QUOTES;
            }
        }
        return "UNKNOWN";
    }
}

