/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableReaderTransformer;
import org.mmbase.util.transformers.UnknownCodingException;

public class Latin3Surrogator
extends ConfigurableReaderTransformer
implements CharTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logging.getLoggerInstance(Latin3Surrogator.class);
    public static final int XMETODO = 1;
    public static final int HMETODO = 2;

    public Latin3Surrogator() {
    }

    public Latin3Surrogator(int c) {
        super(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Writer iksoj(Reader r, Writer w) {
        try {
            block16: while (true) {
                int c;
                if ((c = r.read()) == -1) {
                    return w;
                }
                switch (c) {
                    case 264: {
                        w.write("Cx");
                        continue block16;
                    }
                    case 265: {
                        w.write("cx");
                        continue block16;
                    }
                    case 284: {
                        w.write("Gx");
                        continue block16;
                    }
                    case 285: {
                        w.write("gx");
                        continue block16;
                    }
                    case 292: {
                        w.write("Hx");
                        continue block16;
                    }
                    case 293: {
                        w.write("hx");
                        continue block16;
                    }
                    case 308: {
                        w.write("Jx");
                        continue block16;
                    }
                    case 309: {
                        w.write("jx");
                        continue block16;
                    }
                    case 348: {
                        w.write("Sx");
                        continue block16;
                    }
                    case 349: {
                        w.write("sx");
                        continue block16;
                    }
                    case 364: {
                        w.write("Ux");
                        continue block16;
                    }
                    case 365: {
                        w.write("ux");
                        continue block16;
                    }
                }
                w.write(c);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Writer hoj(Reader r, Writer w) {
        try {
            block16: while (true) {
                int c;
                if ((c = r.read()) == -1) {
                    return w;
                }
                switch (c) {
                    case 264: {
                        w.write("Ch");
                        continue block16;
                    }
                    case 265: {
                        w.write("ch");
                        continue block16;
                    }
                    case 284: {
                        w.write("Gh");
                        continue block16;
                    }
                    case 285: {
                        w.write("gh");
                        continue block16;
                    }
                    case 292: {
                        w.write("Hh");
                        continue block16;
                    }
                    case 293: {
                        w.write("hh");
                        continue block16;
                    }
                    case 308: {
                        w.write("Jh");
                        continue block16;
                    }
                    case 309: {
                        w.write("jh");
                        continue block16;
                    }
                    case 348: {
                        w.write("Sh");
                        continue block16;
                    }
                    case 349: {
                        w.write("sh");
                        continue block16;
                    }
                    case 364: {
                        w.write(85);
                        continue block16;
                    }
                    case 365: {
                        w.write(117);
                        continue block16;
                    }
                }
                w.write(c);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        switch (this.to) {
            case 1: {
                return this.iksoj(r, w);
            }
            case 2: {
                return this.hoj(r, w);
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 1: {
                return "xmetodo";
            }
            case 2: {
                return "hmetodo";
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put("xmetodo".toUpperCase(), new Config(this.getClass(), 1));
        h.put("hmetodo".toUpperCase(), new Config(this.getClass(), 2));
        return h;
    }
}

