/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class Sitestat
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(Sitestat.class);
    private static final String allowedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_-.";

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            int c;
            if (log.isDebugEnabled()) {
                log.debug("Starting transforming string for Sitestat");
            }
            int d = -1;
            while ((c = r.read()) != -1) {
                if (allowedChars.indexOf((char)c) > -1) {
                    w.write((char)c);
                    d = c;
                    continue;
                }
                if (d == 95) continue;
                w.write(95);
                d = 95;
            }
            if (log.isDebugEnabled()) {
                log.debug("Finished transforming string for Sitestat");
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "sitestat";
    }
}

