/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class SpaceSwallower
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(SpaceSwallower.class);

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            log.debug("Starting to remove all space.");
            int c = r.read();
            while (c != -1) {
                if (!Character.isWhitespace((char)c)) {
                    w.write(c);
                }
                c = r.read();
            }
            log.debug("Finished");
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "SPACESWALLOWER";
    }
}

