/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableReaderTransformer;

public class Sql
extends ConfigurableReaderTransformer
implements CharTransformer {
    private static final String ENCODING = "ESCAPE_SINGLE_QUOTE";
    public static final int ESCAPE_QUOTES = 1;

    public Sql() {
        super(1);
    }

    public Sql(int conf) {
        super(conf);
    }

    public static Writer singleQuote(Reader r, Writer w) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == 39) {
                    w.write(c);
                }
                w.write(c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w;
    }

    public static Writer singleQuoteBack(Reader r, Writer w) {
        try {
            int c;
            boolean skipNext = false;
            while ((c = r.read()) != -1) {
                if (c == 39) {
                    if (skipNext) {
                        skipNext = false;
                        continue;
                    }
                    w.write(c);
                    skipNext = true;
                    continue;
                }
                w.write(c);
                skipNext = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w;
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put(ENCODING, new Config(Sql.class, 1, "Escape single quotes for SQL statements"));
        return h;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        switch (this.to) {
            case 1: {
                return Sql.singleQuote(r, w);
            }
        }
        throw new UnsupportedOperationException("Cannot transform");
    }

    @Override
    public Writer transformBack(Reader r, Writer w) {
        switch (this.to) {
            case 1: {
                return Sql.singleQuoteBack(r, w);
            }
        }
        throw new UnsupportedOperationException("Cannot transform");
    }

    @Override
    public String getEncoding() {
        return ENCODING;
    }
}

