/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;

public abstract class StringTransformer
implements CharTransformer {
    private static final Logger log = Logging.getLoggerInstance(StringTransformer.class);

    @Override
    public abstract String transform(String var1);

    @Override
    public final Writer transformBack(Reader r) {
        return this.transformBack(r, new StringWriter());
    }

    @Override
    public final Writer transform(Reader r) {
        return this.transform(r, new StringWriter());
    }

    @Override
    public String transformBack(String r) {
        throw new UnsupportedOperationException("transformBack is not supported for this transformer");
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            int c;
            StringWriter sw = new StringWriter();
            while ((c = r.read()) != -1) {
                sw.write(c);
            }
            String result = this.transform(sw.toString());
            w.write(result);
        }
        catch (IOException e) {
            log.error(e.toString());
            log.debug(Logging.stackTrace(e));
        }
        return w;
    }

    @Override
    public Writer transformBack(Reader r, Writer w) {
        try {
            int c;
            StringWriter sw = new StringWriter();
            while ((c = r.read()) != -1) {
                sw.write(c);
            }
            String result = this.transformBack(sw.toString());
            w.write(result);
        }
        catch (IOException e) {
            log.error(e.toString());
            log.debug(Logging.stackTrace(e));
        }
        return w;
    }
}

