/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class TabToSpacesTransformer
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(TabToSpacesTransformer.class);
    private int spaceNum;
    private String tab;

    public TabToSpacesTransformer() {
        this(3);
    }

    public TabToSpacesTransformer(int spaces) {
        this.spaceNum = spaces;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.spaceNum; ++i) {
            buf.append(' ');
        }
        this.tab = buf.toString();
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == 9) {
                    w.write(this.tab);
                    continue;
                }
                w.write(c);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public Writer transformBack(Reader r, Writer w) {
        int spaces = 1;
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == 32) {
                    if (spaces == this.spaceNum) {
                        w.write(9);
                        spaces = 1;
                        continue;
                    }
                    ++spaces;
                    continue;
                }
                while (spaces > 1) {
                    --spaces;
                    w.write(32);
                }
                w.write(c);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "tab2spacestransformer";
    }
}

