/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.CharTransformerLink;
import org.mmbase.util.transformers.UpperCaser;

public class TransformingReader
extends PipedReader {
    private static final Logger log = Logging.getLoggerInstance(TransformingReader.class);
    private final Reader in;
    private final CharTransformerLink link;

    public TransformingReader(Reader in, CharTransformer charTransformer) {
        this.in = in;
        PipedWriter w = new PipedWriter();
        try {
            this.connect(w);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), ioe);
        }
        this.link = new CharTransformerLink(charTransformer, in, w, true);
        ThreadPools.filterExecutor.execute(this.link);
    }

    @Override
    public synchronized int read() throws IOException {
        int result = super.read();
        if (result == -1) {
            this.waitReady();
            this.in.close();
        }
        return result;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int result = super.read(cbuf, off, len);
        if (result == -1) {
            this.waitReady();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitReady() {
        try {
            while (!this.link.ready()) {
                CharTransformerLink charTransformerLink = this.link;
                synchronized (charTransformerLink) {
                    this.link.wait();
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            log.warn("" + ie.getMessage(), ie);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in.close();
    }

    public static void main(String[] args) {
        BufferedReader reader = new BufferedReader(new TransformingReader(new InputStreamReader(System.in), new UpperCaser()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        ThreadPools.filterExecutor.shutdown();
    }
}

