/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ChainedCharTransformer;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.CharTransformerLink;
import org.mmbase.util.transformers.SpaceReducer;
import org.mmbase.util.transformers.Trimmer;
import org.mmbase.util.transformers.UpperCaser;

public class TransformingWriter
extends PipedWriter {
    private static final Logger log = Logging.getLoggerInstance(TransformingWriter.class);
    private final Writer out;
    private final CharTransformerLink link;

    public TransformingWriter(Writer out, CharTransformer charTransformer) {
        CharTransformerLink l;
        this.out = out;
        PipedReader r = new PipedReader();
        try {
            this.connect(r);
            l = new CharTransformerLink(charTransformer, r, out, false);
            ThreadPools.filterExecutor.execute(l);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
            l = null;
        }
        this.link = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitUntilReady() throws IOException {
        super.close();
        try {
            while (!this.link.ready()) {
                CharTransformerLink charTransformerLink = this.link;
                synchronized (charTransformerLink) {
                    this.link.wait();
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            log.warn("" + ie);
        }
    }

    public Throwable getException() {
        return this.link.getException();
    }

    @Override
    public void close() throws IOException {
        this.waitUntilReady();
        this.out.close();
    }

    public static void main(String[] args) {
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        ChainedCharTransformer t = new ChainedCharTransformer();
        t.add((CharTransformer)new UpperCaser());
        t.add((CharTransformer)new SpaceReducer());
        t.add((CharTransformer)new Trimmer());
        TransformingWriter writer = new TransformingWriter(out, t);
        String testString = "use argument to change this string";
        if (args.length > 0) {
            testString = args[0];
        }
        try {
            writer.write(testString);
            writer.close();
        }
        catch (Exception e) {
            log.error("" + e + Logging.stackTrace(e));
        }
        ThreadPools.filterExecutor.shutdown();
    }
}

