/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ReaderTransformer;

public class UnicodeEscaper
extends ReaderTransformer {
    private static final Logger log = Logging.getLoggerInstance(UnicodeEscaper.class);
    private boolean escapeLow = false;

    public void setEscapeLow(boolean e) {
        this.escapeLow = e;
    }

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c > 127 || this.escapeLow && c < 32) {
                    String hex = Integer.toHexString(c);
                    w.write("\\u");
                    for (int i = hex.length(); i < 4; ++i) {
                        w.write(48);
                    }
                    w.write(hex);
                    continue;
                }
                w.write(c);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public Writer transformBack(Reader r, Writer w) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c == 92) {
                    c = r.read();
                    if (c == -1) {
                        w.write(92);
                        break;
                    }
                    if (c == 117) {
                        StringBuilder hex = new StringBuilder(4);
                        while (c != -1 && hex.length() < 4) {
                            c = r.read();
                            hex.append((char)c);
                        }
                        w.write((char)Integer.parseInt(hex.toString(), 16));
                        continue;
                    }
                    w.write("\\" + (char)c);
                    continue;
                }
                w.write((char)c);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "UnicodeEscaper";
    }
}

