/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableStringTransformer;
import org.mmbase.util.transformers.UnknownCodingException;

public class Url
extends ConfigurableStringTransformer
implements CharTransformer {
    public static final int ESCAPE = 1;
    public static final int PARAM_ESCAPE = 2;

    public Url() {
        super(1);
    }

    public Url(int conf) {
        super(conf);
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put("escape_url".toUpperCase(), new Config(Url.class, 1));
        h.put("escape_url_param".toUpperCase(), new Config(Url.class, 2));
        return h;
    }

    @Override
    public String transform(String r) {
        switch (this.to) {
            case 1: 
            case 2: {
                try {
                    return URLEncoder.encode(r, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    return r;
                }
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    @Override
    public String transformBack(String r) {
        switch (this.to) {
            case 1: 
            case 2: {
                try {
                    return URLDecoder.decode(r, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    return r;
                }
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 1: {
                return "ESCAPE_URL";
            }
            case 2: {
                return "ESCAPE_URL_PARAM";
            }
        }
        throw new UnknownCodingException(this.getClass(), this.to);
    }
}

