/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableStringTransformer;
import org.mmbase.util.transformers.UnknownCodingException;

public class Xml
extends ConfigurableStringTransformer
implements CharTransformer {
    public static final int ESCAPE = 1;
    public static final int ESCAPE_ATTRIBUTE = 2;
    public static final int ESCAPE_ATTRIBUTE_DOUBLE = 3;
    public static final int ESCAPE_ATTRIBUTE_SINGLE = 4;
    public static final int ESCAPE_ATTRIBUTE_HTML = 5;
    public static final Xml INSTANCE = new Xml();
    public static final Xml ATTRIBUTES = new Xml(2);

    public Xml() {
        super(1);
    }

    public Xml(int c) {
        super(c);
    }

    @Override
    public Map<String, Config> transformers() {
        HashMap<String, Config> h = new HashMap<String, Config>();
        h.put("escape_xml".toUpperCase(), new Config(Xml.class, 1, "Escapes >, < & and \""));
        h.put("escape_html".toUpperCase(), new Config(Xml.class, 1, "Like ESCAPE_XML now."));
        h.put("escape_wml".toUpperCase(), new Config(Xml.class, 1, "Like ESCAPE_XML now."));
        h.put("escape_xml_attribute".toUpperCase(), new Config(Xml.class, 2, "Escaping in attributes only involves quotes. This simply escapes both types (which is little too much)."));
        h.put("escape_xml_attribute_double".toUpperCase(), new Config(Xml.class, 3, "Escaping in attributes only involves quotes. This is for double quotes."));
        h.put("escape_xml_attribute_single".toUpperCase(), new Config(Xml.class, 4, "Escaping in attributes only involves quotes. This is for single quotes."));
        h.put("escape_html_attribute".toUpperCase(), new Config(Xml.class, 5, "This escapes all quotes, and also newlines. Handly in some html tags."));
        return h;
    }

    public static String XMLAttributeEscape(String att, char quot) {
        char[] data;
        if (att == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char element : data = att.toCharArray()) {
            char c = element;
            if (c == quot) {
                if (quot == '\"') {
                    sb.append("&quot;");
                    continue;
                }
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String XMLAttributeEscape(String att) {
        char[] data;
        if (att == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char element : data = att.toCharArray()) {
            char c = element;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String XMLEscape(String xml) {
        if (xml == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Xml.XMLEscape(xml, sb);
        return sb.toString();
    }

    public static void XMLEscape(String xml, StringBuilder sb) {
        char[] data;
        for (char element : data = xml.toCharArray()) {
            char c = element;
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
    }

    public static void XMLEscape(String xml, StringBuffer sb) {
        StringBuilder s = new StringBuilder();
        Xml.XMLEscape(xml, s);
        sb.append(s.toString());
    }

    private static String removeNewlines(String incoming) {
        String ret = incoming.replace('\n', ' ');
        return ret.replace('\r', ' ');
    }

    public static String XMLUnescape(String data) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '&') {
                int end = data.indexOf(59, i + 1);
                if (end == -1) {
                    sb.append(c);
                    continue;
                }
                String entity = data.substring(i + 1, end);
                i += entity.length() + 1;
                if ("amp".equals(entity)) {
                    sb.append('&');
                    continue;
                }
                if ("lt".equals(entity)) {
                    sb.append('<');
                    continue;
                }
                if ("gt".equals(entity)) {
                    sb.append('>');
                    continue;
                }
                if ("quot".equals(entity)) {
                    sb.append('\"');
                    continue;
                }
                if ("apos".equals(entity)) {
                    sb.append('\'');
                    continue;
                }
                sb.append("&").append(entity).append(";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public String transform(String r) {
        switch (this.to) {
            case 1: {
                return Xml.XMLEscape(r);
            }
            case 2: {
                return Xml.XMLAttributeEscape(r);
            }
            case 3: {
                return Xml.XMLAttributeEscape(r, '\"');
            }
            case 4: {
                return Xml.XMLAttributeEscape(r, '\'');
            }
            case 5: {
                return Xml.removeNewlines(Xml.XMLAttributeEscape(r));
            }
        }
        throw new UnknownCodingException(this.getClass(), "transform", this.to);
    }

    @Override
    public String transformBack(String r) {
        switch (this.to) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return Xml.XMLUnescape(r);
            }
            case 5: {
                return Xml.XMLUnescape(r);
            }
        }
        throw new UnknownCodingException(this.getClass(), "transformBack", this.to);
    }

    @Override
    public String getEncoding() {
        switch (this.to) {
            case 1: {
                return "ESCAPE_XML";
            }
            case 2: {
                return "ESCAPE_XML_ATTRIBUTE";
            }
            case 3: {
                return "ESCAPE_XML_ATTRIBUTE_DOUBLE";
            }
            case 4: {
                return "ESCAPE_XML_ATTRIBUTE_SINGLE";
            }
            case 5: {
                return "ESCAPE_HTML_ATTRIBUTE";
            }
        }
        throw new UnknownCodingException(this.getClass(), "getEncoding", this.to);
    }
}

