/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.ReaderTransformer;

public class XmlEntities
extends ReaderTransformer
implements CharTransformer {
    private static final Logger log = Logging.getLoggerInstance(XmlEntities.class);

    @Override
    public Writer transform(Reader r, Writer w) {
        try {
            int c;
            while ((c = r.read()) != -1) {
                if (c <= 127) {
                    w.write(c);
                    continue;
                }
                w.write("&#" + c + ";");
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        return w;
    }

    @Override
    public String toString() {
        return "XMLENTITIES";
    }
}

