/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.transformers;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.mmbase.util.logging.JavaScriptErrorReporter;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CopyCharTransformer;
import org.mmbase.util.transformers.ReaderTransformer;
import org.mozilla.javascript.ErrorReporter;

public class YUIJavaScriptCompressor
extends ReaderTransformer {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = Logging.getLoggerInstance(YUIJavaScriptCompressor.class);
    private static final boolean WORKS;
    private boolean munge = true;
    private boolean preserveAllSemiColons = false;
    private boolean disableOptimizations = false;
    private boolean initialNewline = true;
    private int linebreakpos = -1;

    public void setMunge(boolean m) {
        this.munge = m;
    }

    public void setPreserveAllSemiColons(boolean s) {
        this.preserveAllSemiColons = s;
    }

    public void setDisableOptimizations(boolean s) {
        this.disableOptimizations = s;
    }

    public void setLineBreakPosition(int l) {
        this.linebreakpos = l;
    }

    public void setInitialNewline(boolean i) {
        this.initialNewline = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer transform(Reader reader, Writer writer) {
        try {
            if (this.initialNewline) {
                writer.write("\n");
            }
            if (WORKS) {
                LOG.service("Compressing javascript from " + reader + " -> " + writer);
                JavaScriptCompressor compressor = new JavaScriptCompressor(reader, (ErrorReporter)new JavaScriptErrorReporter(LOG));
                compressor.compress(writer, this.linebreakpos, this.munge, false, this.preserveAllSemiColons, this.disableOptimizations);
                LOG.debug("Ready");
            } else {
                CopyCharTransformer.INSTANCE.transform(reader, writer);
            }
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage(), ioe);
        }
        finally {
            LOG.debug(".");
        }
        return writer;
    }

    static {
        boolean w = true;
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader("function a() {}"), (ErrorReporter)new JavaScriptErrorReporter(LOG));
            compressor.compress((Writer)new StringWriter(), 0, false, false, false, false);
            LOG.service("It seams that there are no problems with rhino artifacts, so YUI Compressor can be used.");
        }
        catch (IOException ieo) {
            LOG.warn(ieo.getMessage(), ieo);
            w = false;
        }
        catch (StringIndexOutOfBoundsException sie) {
            LOG.info("Javascript compression not working. See e.g. http://yuilibrary.com/forum/viewtopic.php?f=94&t=3345&p=20085#p20085. " + sie.getMessage());
            w = false;
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.info(ncdfe.getClass().getName() + " " + ncdfe.getMessage() + ". Javascript and CSS compression will not work.");
            w = false;
        }
        catch (RuntimeException re) {
            LOG.info("Javascript comporession not working. You may be running on open jdk. See  https://lists.launchpad.net/openjdk/msg01068.html. ");
            w = false;
        }
        catch (Throwable re) {
            LOG.warn(re.getMessage(), re);
            w = false;
        }
        WORKS = w;
    }
}

