/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.URIResolver;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class DocumentWriter
extends DocumentReader {
    private static final Logger log = Logging.getLoggerInstance(DocumentWriter.class);
    private boolean documentGenerated = false;
    private boolean includeComments = false;
    private ResourceBundle messageRB;
    String publicId = "";
    String systemId = "";

    public DocumentWriter(String qualifiedName, String publicId, String systemId) throws DOMException {
        this(qualifiedName, publicId, systemId, false);
    }

    public DocumentWriter(String qualifiedName, String publicId, String systemId, boolean schema) throws DOMException {
        DOMImplementation domImpl = DocumentReader.getDocumentBuilder().getDOMImplementation();
        if (schema) {
            this.document = domImpl.createDocument(publicId, qualifiedName, null);
            this.document.getDocumentElement().setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.document.getDocumentElement().setAttribute("xsi:schemaLocation", publicId + " " + systemId);
        } else {
            this.publicId = publicId;
            this.systemId = systemId;
            DocumentType doctype = domImpl.createDocumentType(qualifiedName, this.publicId, this.systemId);
            this.document = domImpl.createDocument(null, qualifiedName, doctype);
        }
    }

    public DocumentWriter(InputSource source) {
        super(source);
        this.documentGenerated = true;
    }

    public DocumentWriter(InputSource source, boolean validating, Class<?> resolveBase) {
        super(source, validating, resolveBase);
        this.documentGenerated = true;
    }

    protected void getMessageRetriever(String resourcelocation) {
        try {
            this.messageRB = ResourceBundle.getBundle(resourcelocation);
        }
        catch (MissingResourceException e) {
            log.error("Resource for DocumentWriter is missing: " + resourcelocation);
        }
    }

    protected String getMessage(String key) {
        return this.getMessage(key, "");
    }

    protected String getMessage(String key, String a1) {
        return this.getMessage(key, a1, "", "");
    }

    protected String getMessage(String key, String a1, String a2) {
        return this.getMessage(key, a1, a2, "");
    }

    protected String getMessage(String key, String a1, String a2, String a3) {
        if (this.messageRB != null) {
            try {
                String message = this.messageRB.getString(key);
                Object[] args = new String[]{a1, a2, a3};
                return MessageFormat.format(message, args);
            }
            catch (MissingResourceException e) {
                log.error("Resource for DocumentWriter is broken. There is no " + key + " key in resource.");
            }
        }
        return null;
    }

    protected Element addContentElement(String tagname, String content, Element out) {
        Element el = this.document.createElement(tagname);
        if (content == null) {
            content = "";
        }
        Text tel = this.document.createTextNode(content);
        el.appendChild(tel);
        out.appendChild(el);
        return el;
    }

    protected Comment addComment(String key, Element out) {
        return this.addComment(key, "", "", out);
    }

    protected Comment addComment(String key, String a1, Element out) {
        return this.addComment(key, a1, "", out);
    }

    protected Comment addComment(String key, String a1, String a2, Element out) {
        String message;
        Comment comm = null;
        if (this.includeComments && (message = this.getMessage(key, a1, a2)) != null) {
            comm = this.document.createComment(" " + message + " ");
            out.appendChild(comm);
        }
        return comm;
    }

    protected abstract void generate() throws DOMException;

    public final Document generateDocument() throws DOMException {
        if (!this.documentGenerated) {
            this.generate();
            this.documentGenerated = true;
            return this.document;
        }
        throw new IllegalStateException("Document already constructed");
    }

    @Override
    public Document getDocument() throws DOMException {
        if (!this.documentGenerated) {
            this.generateDocument();
        }
        return this.document;
    }

    public void setIncludeComments(boolean value) {
        this.includeComments = value;
    }

    public boolean includeComments() {
        return this.includeComments;
    }

    public String writeToString() throws TransformerException {
        StringWriter strw = new StringWriter(500);
        this.write(new StreamResult(strw));
        return strw.toString();
    }

    public void writeToFile(String filename) throws IOException, TransformerException {
        this.writeToStream(new FileOutputStream(filename));
    }

    public void writeToStream(OutputStream out) throws TransformerException {
        this.write(new StreamResult(out));
    }

    public void write(StreamResult result) throws TransformerException {
        Document doc = this.getDocument();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        tfactory.setURIResolver(new URIResolver(new File("")));
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("omit-xml-declaration", "no");
        if (this.publicId != null) {
            serializer.setOutputProperty("doctype-public", this.publicId);
        }
        if (this.systemId != null) {
            serializer.setOutputProperty("doctype-system", this.systemId);
        }
        serializer.transform(new DOMSource(doc), result);
    }
}

