/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mmbase.util.Casting;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.Identifier;
import org.mmbase.util.transformers.Xml;
import org.mmbase.util.xml.DocumentReader;
import org.xml.sax.InputSource;

public class EntityResolver
implements org.xml.sax.EntityResolver {
    public static final String DOMAIN = "http://www.mmbase.org/";
    public static final String DTD_SUBPATH = "dtd/";
    public static final String XMLNS_SUBPATH = "xmlns/";
    private static final String XSD_SUBPATH = "xsd/";
    private static final Logger log = Logging.getLoggerInstance(EntityResolver.class);
    private static final String MMRESOURCES = "/org/mmbase/resources/";
    private static Map<String, Resource> publicIDtoResource = new ConcurrentHashMap<String, Resource>();
    private static Map<String, Resource> systemIDtoResource = new ConcurrentHashMap<String, Resource>();
    private final String definitionPath;
    private boolean hasDefinition = false;
    private final boolean validate;
    private final Class<?> resolveBase;
    protected static String ents;

    public static void registerPublicID(String publicID, String dtd, Class<?> c) {
        publicIDtoResource.put(publicID, new FileResource(c, dtd));
        if (log.isDebugEnabled()) {
            log.debug("publicIDtoResource: " + publicID + " " + dtd + c.getName());
        }
    }

    public static void registerSystemID(String systemID, String xsd, Class<?> c) {
        systemIDtoResource.put(systemID, new FileResource(c, xsd));
        if (log.isDebugEnabled()) {
            log.debug("systemIDtoResource: " + systemID + " " + xsd + (c != null ? c.getName() : "NULL") + " " + systemIDtoResource.get(systemID));
        }
    }

    public EntityResolver() {
        this(true);
    }

    public EntityResolver(boolean v) {
        this(v, null);
    }

    public EntityResolver(boolean v, Class<?> base) {
        this.definitionPath = null;
        this.validate = v;
        this.resolveBase = base;
    }

    protected static StringBuilder camelAppend(StringBuilder sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isUpperCase(c)) {
                sb.append(s.substring(i));
                break;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb;
    }

    public static void appendEntities(StringBuilder sb, Object o, String prefix, int level, Set<Object> os) {
        os.add(o);
        Identifier identifier = new Identifier();
        if (o instanceof Map) {
            Set map = ((Map)o).entrySet();
            for (Map.Entry entry : map) {
                Object value = entry.getValue();
                if (value != null && Casting.isStringRepresentable(value.getClass()) && entry.getKey() instanceof String) {
                    sb.append("<!ENTITY ");
                    sb.append(prefix);
                    sb.append('.');
                    String k = identifier.transform((String)entry.getKey());
                    k = k.replaceAll("\\s", "");
                    sb.append(k);
                    sb.append(" \"").append(Xml.XMLAttributeEscape("" + value, '\"').replaceAll("%", "&#x25;")).append("\">\n");
                }
                if (level >= 3 || value == null || os.contains(value) || value.getClass().getName().startsWith("java.lang")) continue;
                EntityResolver.appendEntities(sb, value, prefix + "." + entry.getKey(), level + 1, os);
            }
        } else {
            try {
                for (Method m : o.getClass().getMethods()) {
                    String name = m.getName();
                    if (m.getParameterTypes().length != 0 || "getNodes".equals(name) || "getConnection".equals(name) || name.length() <= 3 || !name.startsWith("get") || !Character.isUpperCase(name.charAt(3))) continue;
                    try {
                        Class<?> rt = m.getReturnType();
                        boolean invoked = false;
                        Object value = null;
                        if (Casting.isStringRepresentable(rt) && !Map.class.isAssignableFrom(rt) && !Collection.class.isAssignableFrom(rt)) {
                            value = m.invoke(o, new Object[0]);
                            invoked = true;
                            sb.append("<!ENTITY ");
                            sb.append(prefix);
                            sb.append('.');
                            EntityResolver.camelAppend(sb, name.substring(3));
                            sb.append(" \"").append(Xml.XMLAttributeEscape("" + value, '\"').replaceAll("%", "&#x25;")).append("\">\n");
                        }
                        if (rt.getName().startsWith("java.lang")) continue;
                        if (!invoked) {
                            value = m.invoke(o, new Object[0]);
                        }
                        if (level >= 3 || value == null || os.contains(value)) continue;
                        EntityResolver.appendEntities(sb, value, prefix + "." + EntityResolver.camelAppend(new StringBuilder(), name.substring(3)), level + 1, os);
                    }
                    catch (IllegalAccessException ia) {
                        log.debug(ia);
                    }
                    catch (InvocationTargetException ite) {
                        log.debug(ite);
                    }
                    catch (AbstractMethodError ame) {
                        log.debug(ame);
                    }
                    catch (Exception e) {
                        log.warn("Error", e);
                    }
                }
            }
            catch (SecurityException se) {
                log.debug(se);
            }
        }
    }

    protected static synchronized String getMMEntities() {
        return ents;
    }

    public static synchronized void setMMEntities(String s) {
        ents = s;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputStreamReader definitionInputStreamReader;
        Resource res;
        if (log.isDebugEnabled()) {
            log.debug("resolving PUBLIC " + publicId + " SYSTEM " + systemId);
        }
        InputStream definitionStream = null;
        String encoding = "UTF-8";
        if ("http://www.mmbase.org/mmentities.ent".equals(systemId)) {
            log.debug("Reding mmbase entities for " + systemId + " " + publicId);
            String entitities = EntityResolver.getMMEntities();
            if (entitities != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using entities\n" + entitities);
                }
                definitionStream = new StringResource(entitities).getStream();
            } else {
                definitionStream = null;
            }
        } else if (publicId != null) {
            res = publicIDtoResource.get(publicId);
            log.debug("Found publicId " + publicId + " -> " + res);
            InputStream inputStream = definitionStream = res == null ? null : res.getStream();
            if (res != null) {
                encoding = res.getEncoding();
            }
        }
        log.debug("Get definition stream by public id: " + definitionStream);
        if (definitionStream == null) {
            res = systemIDtoResource.get(systemId);
            if (res != null) {
                definitionStream = res.getStream();
                encoding = res.getEncoding();
            }
            if (definitionStream == null && systemId.startsWith(DOMAIN) && systemId.endsWith(".xsd")) {
                log.warn("Could not find " + systemId + " in " + systemIDtoResource, new Exception());
            }
            log.debug("Get definition stream by registered system id: " + systemId + " " + definitionStream);
        }
        if (definitionStream == null) {
            log.debug("No definition stream yet");
            if (systemId == null || !systemId.startsWith(DOMAIN)) {
                if (this.validate) {
                    log.debug("Cannot resolve " + systemId + ", but needed for validation leaving to parser.");
                    log.debug("Find culpit: ", new Exception());
                    return null;
                }
                if (systemId.endsWith(".dtd")) {
                    log.debug("Not validating, no need to resolve DTD (?), returning empty resource for " + systemId);
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                log.debug("Cannot resolve " + systemId + ", leaving to parser.");
                return null;
            }
            String mmResource = systemId.substring(DOMAIN.length());
            if (log.isDebugEnabled()) {
                log.debug("mmbase resource " + ResourceLoader.getConfigurationRoot().getResource(mmResource));
            }
            definitionStream = ResourceLoader.getConfigurationRoot().getResourceAsStream(mmResource);
            encoding = "UTF-8";
            if (definitionStream == null) {
                Class<?> base = this.resolveBase;
                Resource res2 = null;
                if (base != null) {
                    res2 = mmResource.startsWith(XMLNS_SUBPATH) ? new FileResource(base, mmResource.substring(6)) : new FileResource(base, mmResource.substring(4));
                }
                if (res2 != null && (definitionStream = res2.getStream()) == null) {
                    log.warn("Could not find " + mmResource + " in " + base.getName() + ", falling back to " + MMRESOURCES + " while resolving " + systemId + " " + publicId);
                    base = null;
                }
                if (base == null) {
                    String resource = MMRESOURCES + mmResource;
                    if (log.isDebugEnabled()) {
                        log.debug("Getting document definition as resource " + resource);
                    }
                    definitionStream = this.getClass().getResourceAsStream(resource);
                }
            } else {
                log.debug("Found resource in mmbase resource loader " + definitionStream);
            }
            if (definitionStream == null) {
                if (this.resolveBase != null) {
                    log.error("Could not find MMBase entity '" + publicId + " " + systemId + "' (did you make a typo?), returning null, system id will be used (needing a connection, or put in config dir) " + this.resolveBase + " " + mmResource, new Exception());
                } else {
                    log.service("Could not find MMBase entity '" + publicId + " " + systemId + "' (did you make a typo?), returning null, system id will be used (needing a connection, or put in config dir)");
                }
                return null;
            }
        }
        this.hasDefinition = true;
        try {
            definitionInputStreamReader = new InputStreamReader(definitionStream, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            log.error(uee);
            definitionInputStreamReader = new InputStreamReader(definitionStream);
        }
        InputSource definitionInputSource = new InputSource();
        if (systemId != null) {
            definitionInputSource.setSystemId(systemId);
        }
        if (publicId != null) {
            definitionInputSource.setPublicId(publicId);
        }
        definitionInputSource.setCharacterStream(definitionInputStreamReader);
        return definitionInputSource;
    }

    public boolean hasDTD() {
        return this.hasDefinition;
    }

    public String getDTDPath() {
        return this.definitionPath;
    }

    static {
        DocumentReader.registerPublicIDs();
        EntityResolver.registerSystemID("http://www.w3.org/2001/03/xml.xsd", "xml.xsd", null);
        EntityResolver.registerSystemID("http://www.w3.org/2001/03/XMLSchema.dtd", "XMLSchema.dtd", null);
        EntityResolver.registerSystemID("http://www.w3.org/2001/03/datatypes.dtd", "datatypes.dtd", null);
        ents = null;
    }

    static class FileResource
    extends Resource {
        private final Class<?> clazz;
        private final String file;

        FileResource(Class<?> c, String f) {
            this.clazz = c;
            this.file = f;
        }

        String getResource() {
            return "resources/" + this.file;
        }

        String getFileName() {
            return this.file;
        }

        @Override
        InputStream getStream() {
            InputStream stream = null;
            if (this.file != null) {
                stream = ResourceLoader.getConfigurationRoot().getResourceAsStream(EntityResolver.DTD_SUBPATH + this.getFileName());
                if (stream == null) {
                    stream = ResourceLoader.getConfigurationRoot().getResourceAsStream(EntityResolver.XMLNS_SUBPATH + this.getFileName());
                }
                if (stream == null) {
                    stream = ResourceLoader.getConfigurationRoot().getResourceAsStream(EntityResolver.XSD_SUBPATH + this.getFileName());
                }
            }
            if (stream == null && this.clazz != null) {
                stream = this.clazz.getResourceAsStream(this.getResource());
            }
            return stream;
        }

        public String toString() {
            return this.file + ": " + this.clazz;
        }
    }

    static class StringResource
    extends Resource {
        private String string;

        StringResource(String s) {
            this.string = s;
        }

        @Override
        InputStream getStream() {
            try {
                return new ByteArrayInputStream(this.string.getBytes(this.encoding));
            }
            catch (UnsupportedEncodingException uee) {
                log.error(uee);
                return new ByteArrayInputStream(this.string.getBytes());
            }
        }
    }

    static abstract class Resource {
        String encoding = "UTF-8";

        Resource() {
        }

        abstract InputStream getStream();

        public String getEncoding() {
            return this.encoding;
        }
    }
}

