/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.xml;

import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandler
implements org.xml.sax.ErrorHandler {
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL_ERROR = 3;
    public static final int NEVER = 4;
    private static final Logger log = Logging.getLoggerInstance(ErrorHandler.class);
    private int exceptionLevel;
    private boolean logMessages;
    private boolean warning = false;
    private boolean error = false;
    private boolean fatal = false;
    private StringBuilder messages = new StringBuilder();

    public ErrorHandler() {
        this.logMessages = true;
        this.exceptionLevel = 4;
    }

    public ErrorHandler(boolean log, int exceptionLevel) {
        this.logMessages = log;
        this.exceptionLevel = exceptionLevel;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        String message = this.getLocationString(ex) + ": " + ex.getMessage();
        this.messages.append(message).append("\n");
        this.warning = true;
        if (this.logMessages) {
            log.warn(message);
        }
        if (this.exceptionLevel <= 1) {
            throw ex;
        }
    }

    private boolean isJava5AndXInclude(Exception ex) {
        if (("" + System.getProperty("java.version")).startsWith("1.5")) {
            for (StackTraceElement el : ex.getStackTrace()) {
                if (!el.getClassName().equals("com.sun.org.apache.xerces.internal.xinclude.XIncludeHandler")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        String message = this.getLocationString(ex) + ": " + ex.getClass() + " " + ex.getMessage();
        if (this.isJava5AndXInclude(ex)) {
            log.debug(message + " (this probably does not make sense)");
            return;
        }
        this.messages.append(message).append("\n");
        this.error = true;
        if (this.logMessages) {
            if (log.isDebugEnabled()) {
                log.error(message, new Throwable());
            } else {
                log.error(message);
            }
        }
        if (this.exceptionLevel <= 2) {
            throw ex;
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        String message = this.getLocationString(ex) + ": " + ex.getMessage();
        this.messages.append(message).append("\n");
        this.fatal = true;
        if (this.logMessages) {
            log.fatal(message, ex);
        }
        if (this.exceptionLevel <= 3) {
            throw ex;
        }
    }

    public boolean foundWarning() {
        return this.warning;
    }

    public boolean foundError() {
        return this.error;
    }

    public boolean foundFatalError() {
        return this.fatal;
    }

    public boolean foundNothing() {
        return !this.warning && !this.error && !this.fatal;
    }

    public String getMessageBuffer() {
        return this.messages.toString();
    }

    private String getLocationString(SAXParseException ex) {
        StringBuilder str = new StringBuilder();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            str.append(systemId);
        } else {
            str.append("[NO SYSTEM ID]");
        }
        str.append(" line:");
        str.append(ex.getLineNumber());
        str.append(" column:");
        str.append(ex.getColumnNumber());
        return str.toString();
    }
}

