/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.connector.dav.WebDavSupport;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.slf4j.LoggerFactory;

public abstract class AbstractDavResource<T extends WebDavSupport>
implements DavResource {
    private final DavResourceFactory factory;
    private final DavResourceLocator locator;
    private final DavResource parent;
    private final List<DavResource> children;
    protected final DavPropertySet properties;
    protected final T client;
    private boolean exists;

    public AbstractDavResource(DavResourceFactory factory, DavResourceLocator locator, DavPropertySet properties, T client, DavResource parent) {
        this.factory = factory;
        this.locator = locator;
        this.properties = properties;
        this.client = client;
        this.parent = parent;
        this.children = new ArrayList<DavResource>();
    }

    public String getComplianceClass() {
        return "";
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK";
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public boolean isCollection() {
        DavProperty<T> resourceType = this.getPropertyInternal(DavPropertyName.RESOURCETYPE);
        return resourceType != null && ((String)resourceType.getValue()).equals("collection");
    }

    public String getDisplayName() {
        DavProperty<T> displayName = this.getPropertyInternal(DavPropertyName.DISPLAYNAME);
        return displayName != null ? (String)displayName.getValue() : null;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public boolean exists() {
        if (!this.exists) {
            try {
                this.exists = (Boolean)this.client.head(this.getResourcePath(), response -> response.getStatusLine().getStatusCode() != 404);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(AbstractDavResource.class).error("Server request failed", (Throwable)e);
            }
        }
        return this.exists;
    }

    public long getModificationTime() {
        DavProperty<T> lastModified = this.getPropertyInternal(DavPropertyName.GETLASTMODIFIED);
        return lastModified != null ? (Long)lastModified.getValue() : -1L;
    }

    public DavPropertySet getProperties() {
        DavPropertySet copy = new DavPropertySet();
        copy.addAll(this.properties);
        return copy;
    }

    public DavPropertyName[] getPropertyNames() {
        try {
            return this.client.propFindAll(this.getResourcePath()).getPropertyNames();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DavProperty<?> getProperty(DavPropertyName name) {
        DavProperty property = this.properties.get(name);
        if (property == null) {
            try {
                DavPropertySet result = this.client.propFind(this.getResourcePath(), name);
                this.properties.addAll(result);
                property = this.properties.get(name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return property;
    }

    private <T> DavProperty<T> getPropertyInternal(DavPropertyName name) {
        return this.getProperty(name);
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public DavResourceFactory getFactory() {
        return this.factory;
    }

    public void setProperty(DavProperty<?> property) throws DavException {
        try {
            this.client.propPatchSet(this.getResourcePath(), property);
            this.properties.add(property);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        try {
            this.properties.remove(propertyName);
            this.client.propPatchRemove(this.getResourcePath(), propertyName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        try {
            return this.client.propPatch(this.getResourcePath(), changeList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DavResource getCollection() {
        return this.parent;
    }

    public DavResourceIterator getMembers() {
        return new DavResourceIteratorImpl(this.children);
    }

    public void move(DavResource destination) throws DavException {
        try {
            this.client.move(this.getResourcePath(), destination.getResourcePath());
            this.exists = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        try {
            this.client.copy(this.getResourcePath(), destination.getResourcePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLockable(Type type, Scope scope) {
        return false;
    }

    public boolean hasLock(Type type, Scope scope) {
        return false;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return null;
    }

    public ActiveLock[] getLocks() {
        return new ActiveLock[0];
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        return null;
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        return null;
    }

    public void unlock(String lockToken) throws DavException {
    }

    public void addLockManager(LockManager lockmgr) {
    }

    public DavSession getSession() {
        return null;
    }
}

