/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectCollection;
import net.fortuna.ical4j.connector.dav.CalDavCalendarStore;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.DavPropertyBuilder;
import net.fortuna.ical4j.connector.dav.property.ICalPropertyName;
import net.fortuna.ical4j.connector.dav.request.CalendarQuery;
import net.fortuna.ical4j.connector.dav.request.EventQuery;
import net.fortuna.ical4j.connector.dav.response.GetCalendarData;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CalDavCalendarCollection
extends AbstractDavObjectCollection<Calendar>
implements CalendarCollection {
    CalDavCalendarCollection(CalDavCalendarStore calDavCalendarStore, String id) {
        this(calDavCalendarStore, id, null, null);
    }

    CalDavCalendarCollection(CalDavCalendarStore calDavCalendarStore, String id, String displayName, String description) {
        super(calDavCalendarStore, id);
        this.properties.add(new DavPropertyBuilder().name(DavPropertyName.DISPLAYNAME).value(displayName).build());
        this.properties.add(new DavPropertyBuilder().name(CalDavPropertyName.CALENDAR_DESCRIPTION).value(description).build());
    }

    CalDavCalendarCollection(CalDavCalendarStore calDavCalendarStore, String id, DavPropertySet _properties) {
        this(calDavCalendarStore, id, null, null);
        this.properties = _properties;
    }

    final void create() throws IOException, ObjectStoreException {
        try {
            this.getStore().getClient().mkCalendar(this.getPath(), this.properties);
        }
        catch (DavException e) {
            throw new ObjectStoreException("Failed to create calendar collection", e);
        }
    }

    @Deprecated
    public Calendar[] getCalendars() {
        return this.getComponentsByType("VEVENT");
    }

    public Calendar[] getEvents() {
        return this.getComponentsByType("VEVENT");
    }

    public Calendar[] getTasks() {
        return this.getComponentsByType("VTODO");
    }

    public Calendar[] getComponentsByType(String componentType) {
        try {
            DavPropertyNameSet propertyNames = new DavPropertyNameSet();
            propertyNames.add(DavPropertyName.GETETAG);
            propertyNames.add(CalDavPropertyName.CALENDAR_DATA);
            ReportInfo info = new ReportInfo(CalDavPropertyName.CALENDAR_QUERY, 1, propertyNames);
            info.setContentElement(new CalendarQuery(componentType).build());
            List<Calendar> calendars = this.getStore().getClient().report(this.getPath(), info, new GetCalendarData());
            return calendars.toArray(new Calendar[0]);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDescription() {
        try {
            return this.getProperty(CalDavPropertyName.CALENDAR_DESCRIPTION, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getProperty(DavPropertyName.DISPLAYNAME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer getMaxAttendeesPerInstance() {
        try {
            return this.getProperty(CalDavPropertyName.MAX_ATTENDEES_PER_INSTANCE, Integer.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMaxDateTime() {
        try {
            return this.getProperty(CalDavPropertyName.MAX_DATE_TIME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer getMaxInstances() {
        try {
            return this.getProperty(CalDavPropertyName.MAX_INSTANCES, Integer.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getMaxResourceSize() {
        try {
            Long size = this.getProperty(CalDavPropertyName.MAX_RESOURCE_SIZE, Long.class);
            if (size != null) {
                return size;
            }
            return 0L;
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMinDateTime() {
        try {
            return this.getProperty(CalDavPropertyName.MIN_DATE_TIME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getSupportedComponentTypes() {
        ArrayList<String> supportedComponents = new ArrayList<String>();
        try {
            ArrayList supportedCalCompSetProp = this.getProperty(CalDavPropertyName.SUPPORTED_CALENDAR_COMPONENT_SET, ArrayList.class);
            if (supportedCalCompSetProp != null) {
                for (Node child : supportedCalCompSetProp) {
                    Node nameNode;
                    if (!(child instanceof Element) || (nameNode = child.getAttributes().getNamedItem("name")) == null) continue;
                    supportedComponents.add(nameNode.getTextContent());
                }
            }
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
        return supportedComponents.toArray(new String[supportedComponents.size()]);
    }

    @Override
    public Calendar getTimeZone() {
        try {
            String calTimezoneProp = this.getProperty(CalDavPropertyName.CALENDAR_TIMEZONE, String.class);
            if (calTimezoneProp != null) {
                CalendarBuilder builder = new CalendarBuilder();
                return builder.build((Reader)new StringReader(calTimezoneProp));
            }
            return new Calendar();
        }
        catch (IOException | ObjectStoreException | ParserException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public String getColor() {
        try {
            return this.getProperty(ICalPropertyName.CALENDAR_COLOR, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public int getOrder() {
        try {
            return this.getProperty(ICalPropertyName.CALENDAR_ORDER, Integer.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        this.writeCalendarOnServer(calendar, true);
    }

    public void addCalendar(String uri, Calendar calendar) throws ObjectStoreException {
        this.writeCalendarOnServer(uri, calendar, true);
    }

    public void updateCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        this.writeCalendarOnServer(calendar, false);
    }

    public void updateCalendar(String uri, Calendar calendar) throws ObjectStoreException {
        this.writeCalendarOnServer(uri, calendar, false);
    }

    public void writeCalendarOnServer(Calendar calendar, boolean isNew) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = Calendars.getUid((Calendar)calendar);
        this.writeCalendarOnServer(this.defaultUriFromUid(uid.getValue()), calendar, isNew);
    }

    public void writeCalendarOnServer(String uri, Calendar calendar, boolean isNew) throws ObjectStoreException {
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        try {
            this.getStore().getClient().put(path + uri, calendar, isNew ? null : "*");
        }
        catch (IOException | FailedOperationException e) {
            throw new ObjectStoreException("Error creating calendar on server", e);
        }
    }

    @Override
    public Calendar getCalendar(String uid) throws ObjectNotFoundException {
        return this.getCalendarFromUri(this.defaultUriFromUid(uid));
    }

    public Calendar getCalendarFromUri(String uri) throws ObjectNotFoundException {
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        try {
            return this.getStore().getClient().getCalendar(path + uri);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Calendar removeCalendar(String uid) throws FailedOperationException, ObjectStoreException, ObjectNotFoundException {
        return this.removeCalendarFromUri(this.defaultUriFromUid(uid));
    }

    public Calendar removeCalendarFromUri(String uri) throws FailedOperationException, ObjectStoreException, ObjectNotFoundException {
        Calendar calendar = this.getCalendarFromUri(uri);
        try {
            this.getStore().getClient().delete(this.getPath() + "/" + uri);
        }
        catch (IOException | DavException e) {
            throw new ObjectStoreException(e);
        }
        return calendar;
    }

    @Override
    public final void merge(Calendar calendar) throws FailedOperationException, ObjectStoreException {
        try {
            Calendar[] uidCalendars = Calendars.split((Calendar)calendar);
            for (int i = 0; i < uidCalendars.length; ++i) {
                this.addCalendar(uidCalendars[i]);
            }
        }
        catch (ConstraintViolationException cve) {
            throw new FailedOperationException("Invalid calendar format", cve);
        }
    }

    @Override
    public Calendar export() throws ObjectStoreException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Calendar[] getComponents() throws ObjectStoreException {
        return this.getComponentsByType("VEVENT");
    }

    public List<Calendar> getEventsForTimePeriod(DateTime startTime, DateTime endTime) throws IOException, DavException, ParserConfigurationException, ParserException {
        return this.getStore().getClient().report(this.getPath(), new EventQuery(1).withStartTime(startTime).withEndTime(endTime), new GetCalendarData());
    }

    public Calendar[] getObjectsByMultiget(ArrayList<URI> hrefs, Element calData) throws IOException, DavException, ParserConfigurationException, ParserException {
        return new Calendar[0];
    }

    public Calendar[] doFreeBusyQuery() {
        return new Calendar[0];
    }

    public static final DavPropertyNameSet propertiesForFetch() {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(BaseDavPropertyName.QUOTA_AVAILABLE_BYTES);
        principalsProps.add(BaseDavPropertyName.QUOTA_USED_BYTES);
        principalsProps.add(SecurityConstants.CURRENT_USER_PRIVILEGE_SET);
        principalsProps.add(BaseDavPropertyName.PROP);
        principalsProps.add(DavPropertyName.RESOURCETYPE);
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        principalsProps.add(SecurityConstants.OWNER);
        principalsProps.add(CalDavPropertyName.CALENDAR_DESCRIPTION);
        principalsProps.add(CalDavPropertyName.SUPPORTED_CALENDAR_COMPONENT_SET);
        principalsProps.add(CalDavPropertyName.FREE_BUSY_SET);
        principalsProps.add(CalDavPropertyName.SCHEDULE_CALENDAR_TRANSP);
        principalsProps.add(CalDavPropertyName.SCHEDULE_DEFAULT_CALENDAR_URL);
        principalsProps.add(CalDavPropertyName.CALENDAR_TIMEZONE);
        principalsProps.add(CalDavPropertyName.SUPPORTED_CALENDAR_DATA);
        principalsProps.add(CalDavPropertyName.MAX_ATTENDEES_PER_INSTANCE);
        principalsProps.add(CalDavPropertyName.MAX_DATE_TIME);
        principalsProps.add(CalDavPropertyName.MIN_DATE_TIME);
        principalsProps.add(CalDavPropertyName.MAX_INSTANCES);
        principalsProps.add(CalDavPropertyName.MAX_RESOURCE_SIZE);
        principalsProps.add(CSDavPropertyName.XMPP_SERVER);
        principalsProps.add(CSDavPropertyName.XMPP_URI);
        principalsProps.add(CSDavPropertyName.CTAG);
        principalsProps.add(CSDavPropertyName.SOURCE);
        principalsProps.add(CSDavPropertyName.SUBSCRIBED_STRIP_ALARMS);
        principalsProps.add(CSDavPropertyName.SUBSCRIBED_STRIP_ATTACHMENTS);
        principalsProps.add(CSDavPropertyName.SUBSCRIBED_STRIP_TODOS);
        principalsProps.add(CSDavPropertyName.REFRESHRATE);
        principalsProps.add(CSDavPropertyName.PUSH_TRANSPORTS);
        principalsProps.add(CSDavPropertyName.PUSHKEY);
        principalsProps.add(ICalPropertyName.CALENDAR_COLOR);
        principalsProps.add(ICalPropertyName.CALENDAR_ORDER);
        return principalsProps;
    }

    public String toString() {
        return "Display Name: " + this.getDisplayName() + ", id: " + this.getId();
    }

    private String defaultUriFromUid(String uid) {
        return uid + ".ics";
    }
}

