/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.CalendarStore;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectStore;
import net.fortuna.ical4j.connector.dav.CalDavCalendarCollection;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.connector.dav.ResourceType;
import net.fortuna.ical4j.connector.dav.ScheduleResponse;
import net.fortuna.ical4j.connector.dav.method.PrincipalPropertySearchInfo;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.request.ExpandPropertyQuery;
import net.fortuna.ical4j.connector.dav.request.PrincipalPropertySearch;
import net.fortuna.ical4j.connector.dav.response.GetCalDavCollections;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.FixedUidGenerator;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class CalDavCalendarStore
extends AbstractDavObjectStore<CalDavCalendarCollection>
implements CalendarStore<CalDavCalendarCollection> {
    private final String prodId;
    private String displayName;

    public CalDavCalendarStore(String prodId, URL url, PathResolver pathResolver) {
        super(url, pathResolver);
        this.prodId = prodId;
    }

    @Override
    public CalDavCalendarCollection addCollection(String id) throws ObjectStoreException {
        CalDavCalendarCollection collection = new CalDavCalendarCollection(this, id);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    @Override
    public CalDavCalendarCollection addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        CalDavCalendarCollection collection = new CalDavCalendarCollection(this, id, displayName, description);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    public CalDavCalendarCollection addCollection(String id, DavPropertySet properties) throws ObjectStoreException {
        CalDavCalendarCollection collection = new CalDavCalendarCollection(this, id, properties);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    @Override
    public CalDavCalendarCollection getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        try {
            DavPropertyNameSet principalsProps = CalDavCalendarCollection.propertiesForFetch();
            return (CalDavCalendarCollection)this.getClient().propFindResources(id, principalsProps, ResourceType.CALENDAR, ResourceType.CALENDAR_PROXY_READ, ResourceType.CALENDAR_PROXY_WRITE).entrySet().stream().map(e -> new CalDavCalendarCollection(this, (String)e.getKey(), (DavPropertySet)e.getValue())).collect(Collectors.toList()).get(0);
        }
        catch (IOException e2) {
            throw new ObjectStoreException(String.format("unable to get collection '%s'", id), e2);
        }
    }

    public CalendarCollection merge(String id, CalendarCollection calendar) {
        throw new UnsupportedOperationException("not implemented");
    }

    public String findCalendarHomeSet() throws ParserConfigurationException, IOException, DavException {
        String propfindUri = this.getHostURL() + this.pathResolver.getPrincipalPath(this.getUserName());
        return this.findCalendarHomeSet(propfindUri);
    }

    protected String findCalendarHomeSet(String propfindUri) throws IOException {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(CalDavPropertyName.CALENDAR_HOME_SET);
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        DavPropertySet props = this.getClient().propFind(propfindUri, principalsProps);
        if (props.contains(CalDavPropertyName.CALENDAR_HOME_SET)) {
            return (String)props.get(CalDavPropertyName.CALENDAR_HOME_SET).getValue();
        }
        throw new RuntimeException("Property not found");
    }

    @Override
    public List<CalDavCalendarCollection> getCollections() throws ObjectStoreException, ObjectNotFoundException {
        try {
            String calHomeSetUri = this.findCalendarHomeSet();
            if (calHomeSetUri == null) {
                throw new ObjectNotFoundException("No calendar-home-set attribute found for the user");
            }
            String urlForcalendarHomeSet = this.getHostURL() + calHomeSetUri;
            return this.getCollectionsForHomeSet(this, urlForcalendarHomeSet);
        }
        catch (DavException de) {
            throw new ObjectStoreException(de);
        }
        catch (IOException ioe) {
            throw new ObjectStoreException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new ObjectStoreException(pce);
        }
    }

    protected List<CalDavCalendarCollection> getCollectionsForHomeSet(CalDavCalendarStore store, String urlForcalendarHomeSet) throws IOException, DavException {
        DavPropertyNameSet principalsProps = CalDavCalendarCollection.propertiesForFetch();
        return this.getClient().propFindResources(urlForcalendarHomeSet, principalsProps, ResourceType.CALENDAR, ResourceType.CALENDAR_PROXY_READ, ResourceType.CALENDAR_PROXY_WRITE).entrySet().stream().map(e -> new CalDavCalendarCollection(this, (String)e.getKey(), (DavPropertySet)e.getValue())).collect(Collectors.toList());
    }

    public List<CalDavCalendarCollection> getDelegatedCollections() throws Exception {
        ArrayList<CalDavCalendarCollection> collections = new ArrayList<CalDavCalendarCollection>();
        collections.addAll(this.getWriteDelegatedCollections());
        collections.addAll(this.getReadOnlyDelegatedCollections());
        return collections;
    }

    protected List<CalDavCalendarCollection> getDelegatedCollections(ExpandPropertyQuery.Type type) throws Exception {
        String methodUri = this.pathResolver.getPrincipalPath(this.getUserName());
        ExpandPropertyQuery expandPropertyReport = new ExpandPropertyQuery(type).withPropertyName(DavPropertyName.DISPLAYNAME).withPropertyName(SecurityConstants.PRINCIPAL_URL).withPropertyName(CalDavPropertyName.USER_ADDRESS_SET);
        ReportInfo rinfo = new ReportInfo(BaseDavPropertyName.EXPAND_PROPERTY, 0);
        rinfo.setContentElement(expandPropertyReport.build());
        return this.getClient().report(methodUri, rinfo, new GetCalDavCollections());
    }

    public List<CalDavCalendarCollection> getWriteDelegatedCollections() throws Exception {
        List<CalDavCalendarCollection> collections = this.getDelegatedCollections(ExpandPropertyQuery.Type.PROXY_WRITE_FOR);
        return collections;
    }

    public List<CalDavCalendarCollection> getReadOnlyDelegatedCollections() throws Exception {
        List<CalDavCalendarCollection> collections = this.getDelegatedCollections(ExpandPropertyQuery.Type.PROXY_READ_FOR);
        return collections;
    }

    @Override
    public CalDavCalendarCollection removeCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        CalDavCalendarCollection collection = this.getCollection(id);
        try {
            collection.delete();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to remove collection '%s'", id), e);
        }
        return collection;
    }

    final String getProdId() {
        return this.prodId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String findScheduleOutbox() throws ParserConfigurationException, IOException, DavException {
        return this.findInboxOrOutbox(CalDavPropertyName.SCHEDULE_OUTBOX_URL);
    }

    public String findScheduleInbox() throws ParserConfigurationException, IOException, DavException {
        return this.findInboxOrOutbox(CalDavPropertyName.SCHEDULE_INBOX_URL);
    }

    protected String findInboxOrOutbox(DavPropertyName type) throws ParserConfigurationException, IOException, DavException {
        String propfindUri = this.pathResolver.getPrincipalPath(this.getUserName());
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(type);
        DavPropertySet props = this.getClient().propFind(propfindUri, principalsProps);
        return (String)props.get(type).getValue();
    }

    public List<ScheduleResponse> findFreeBusyInfoForAttendees(Organizer organizer, ArrayList<Attendee> attendees, DtStart startTime, DtEnd endTime) throws ParserConfigurationException, IOException, DavException, ParseException, ParserException, SAXException {
        Random ramdomizer = new Random();
        ArrayList responses = new ArrayList();
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId(this.getProdId()));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        calendar.getProperties().add((Property)Method.REQUEST);
        VFreeBusy fbComponent = new VFreeBusy();
        fbComponent.getProperties().add((Property)organizer);
        fbComponent.getProperties().add((Property)startTime);
        fbComponent.getProperties().add((Property)endTime);
        String strAttendee = "";
        if (attendees != null) {
            for (Attendee attendee : attendees) {
                fbComponent.getProperties().add((Property)attendee);
                strAttendee = strAttendee + attendee.getValue() + ",";
            }
            strAttendee = strAttendee.substring(0, strAttendee.length() - 1);
        }
        FixedUidGenerator ug = new FixedUidGenerator(ramdomizer.nextInt() + "");
        fbComponent.getProperties().add((Property)ug.generateUid());
        calendar.getComponents().add((Object)fbComponent);
        return this.getClient().freeBusy(this.findScheduleOutbox(), calendar, organizer);
    }

    public List<Attendee> getIndividuals(String nameToSearch) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getUserTypes(CuType.INDIVIDUAL, nameToSearch);
    }

    public List<Attendee> getRooms(String nameToSearch) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getUserTypes(CuType.ROOM, nameToSearch);
    }

    public List<Attendee> getAllRooms() throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getAllPrincipalsForType(CuType.ROOM);
    }

    public List<Attendee> getAllResources() throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.getAllPrincipalsForType(CuType.RESOURCE);
    }

    public List<Attendee> getAllPrincipalsForType(CuType type) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.executePrincipalPropSearch(new PrincipalPropertySearch(type).build());
    }

    protected List<Attendee> getUserTypes(CuType type, String nameToSearch) throws ParserConfigurationException, IOException, DavException, URISyntaxException {
        return this.executePrincipalPropSearch(new PrincipalPropertySearch(type, nameToSearch).build());
    }

    protected List<Attendee> executePrincipalPropSearch(Element principalPropSearch) throws DavException, IOException, URISyntaxException {
        PrincipalPropertySearchInfo rinfo = new PrincipalPropertySearchInfo(principalPropSearch, 0);
        String methodUri = this.pathResolver.getPrincipalPath(this.getUserName());
        return this.getClient().findPrincipals(methodUri, rinfo);
    }
}

