/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.WebDavSupport;
import net.fortuna.ical4j.connector.dav.request.CalendarQuery;
import net.fortuna.ical4j.connector.dav.response.GetCalendarResource;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.client.ResponseHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;

public interface CalDavSupport
extends WebDavSupport {
    public void mkCalendar(String var1, DavPropertySet var2) throws IOException, ObjectStoreException, DavException;

    default public Map<String, DavPropertySet> report(String path, CalendarQuery query, ReportType reportType, DavPropertyName ... propertyNames) throws IOException, ParserConfigurationException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        Arrays.stream(propertyNames).forEach(arg_0 -> ((DavPropertyNameSet)nameSet).add(arg_0));
        return this.report(path, query, reportType, nameSet);
    }

    public Map<String, DavPropertySet> report(String var1, CalendarQuery var2, ReportType var3, DavPropertyNameSet var4) throws IOException, ParserConfigurationException;

    public <T> T report(String var1, ReportInfo var2, ResponseHandler<T> var3) throws IOException, ParserConfigurationException;

    public void put(String var1, Calendar var2, String var3) throws IOException, FailedOperationException;

    default public Calendar getCalendar(String path) throws IOException {
        return this.get(path, new GetCalendarResource());
    }
}

