/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CardCollection;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectCollection;
import net.fortuna.ical4j.connector.dav.CardDavStore;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CardDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.DavPropertyBuilder;
import net.fortuna.ical4j.connector.dav.response.GetVCardData;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.property.Uid;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;

public class CardDavCollection
extends AbstractDavObjectCollection<VCard>
implements CardCollection {
    CardDavCollection(CardDavStore CardDavCalendarStore, String id) {
        this(CardDavCalendarStore, id, null, null);
    }

    CardDavCollection(CardDavStore CardDavCalendarStore, String id, String displayName, String description) {
        super(CardDavCalendarStore, id);
        this.properties.add(new DavPropertyBuilder().name(DavPropertyName.DISPLAYNAME).value(displayName).build());
        this.properties.add(new DavPropertyBuilder().name(CalDavPropertyName.CALENDAR_DESCRIPTION).value(description).build());
    }

    CardDavCollection(CardDavStore CardDavCalendarStore, String id, DavPropertySet _properties) {
        this(CardDavCalendarStore, id, null, null);
        this.properties = _properties;
    }

    final void create() throws IOException, ObjectStoreException {
        try {
            this.getStore().getClient().mkCalendar(this.getPath(), this.properties);
        }
        catch (DavException e) {
            throw new ObjectStoreException("Failed to create collection", e);
        }
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getProperty(DavPropertyName.DISPLAYNAME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public long getMaxResourceSize() {
        try {
            Long size = this.getProperty(CalDavPropertyName.MAX_RESOURCE_SIZE, Long.class);
            if (size != null) {
                return size;
            }
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
        return 0L;
    }

    public Calendar export() throws ObjectStoreException {
        throw new UnsupportedOperationException("not implemented");
    }

    public static final DavPropertyNameSet propertiesForFetch() {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        principalsProps.add(SecurityConstants.CURRENT_USER_PRIVILEGE_SET);
        principalsProps.add(DavPropertyName.RESOURCETYPE);
        principalsProps.add(SecurityConstants.OWNER);
        principalsProps.add(CardDavPropertyName.MAX_RESOURCE_SIZE);
        principalsProps.add(BaseDavPropertyName.RESOURCE_ID);
        principalsProps.add(BaseDavPropertyName.SUPPORTED_REPORT_SET);
        principalsProps.add(BaseDavPropertyName.SYNC_TOKEN);
        principalsProps.add(BaseDavPropertyName.ADD_MEMBER);
        principalsProps.add(CardDavPropertyName.MAX_IMAGE_SIZE);
        principalsProps.add(CardDavPropertyName.SUPPORTED_ADDRESS_DATA);
        return principalsProps;
    }

    @Override
    public String getDescription() {
        return null;
    }

    public VCard[] getComponents() throws ObjectStoreException {
        try {
            DavPropertyNameSet properties = new DavPropertyNameSet();
            properties.add(DavPropertyName.GETETAG);
            properties.add(CardDavPropertyName.ADDRESS_DATA);
            ReportInfo info = new ReportInfo(CardDavPropertyName.ADDRESSBOOK_QUERY, 1, properties);
            return this.getStore().getClient().report(this.getPath(), info, new GetVCardData()).toArray(new VCard[0]);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addCard(VCard card) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = (Uid)card.getProperty(Property.Id.UID);
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        try {
            this.getStore().getClient().put(path + uid.getValue() + ".vcf", card, null);
        }
        catch (IOException | FailedOperationException e) {
            throw new ObjectStoreException("Error creating calendar on server", e);
        }
    }

    @Override
    public VCard removeCard(String uid) throws ObjectNotFoundException, FailedOperationException {
        return null;
    }
}

