/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.CardStore;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectStore;
import net.fortuna.ical4j.connector.dav.CardDavCollection;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.connector.dav.ResourceType;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CardDavPropertyName;
import net.fortuna.ical4j.connector.dav.request.ExpandPropertyQuery;
import net.fortuna.ical4j.connector.dav.response.GetCardDavCollections;
import net.fortuna.ical4j.model.Calendar;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;

public final class CardDavStore
extends AbstractDavObjectStore<CardDavCollection>
implements CardStore<CardDavCollection> {
    private final String prodId;
    private String displayName;

    public CardDavStore(String prodId, URL url) {
        this(prodId, url, null);
    }

    public CardDavStore(String prodId, URL url, PathResolver pathResolver) {
        super(url, pathResolver);
        this.prodId = prodId;
    }

    @Override
    public CardDavCollection addCollection(String id) throws ObjectStoreException {
        CardDavCollection collection = new CardDavCollection(this, id);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    public CardDavCollection addCollection(String id, DavPropertySet properties) throws ObjectStoreException {
        CardDavCollection collection = new CardDavCollection(this, id, properties);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    @Override
    public CardDavCollection getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        try {
            DavPropertyNameSet principalsProps = CardDavCollection.propertiesForFetch();
            return (CardDavCollection)this.getClient().propFindResources(id, principalsProps, ResourceType.ADRESSBOOK).entrySet().stream().map(e -> new CardDavCollection(this, (String)e.getKey(), (DavPropertySet)e.getValue())).collect(Collectors.toList()).get(0);
        }
        catch (IOException e2) {
            throw new ObjectStoreException(String.format("unable to get collection '%s'", id), e2);
        }
    }

    public CalendarCollection merge(String id, CalendarCollection calendar) {
        throw new UnsupportedOperationException("not implemented");
    }

    protected String findAddressBookHomeSet() throws ParserConfigurationException, IOException, DavException {
        String propfindUri = this.getHostURL() + this.pathResolver.getPrincipalPath(this.getUserName());
        return this.findAddressBookHomeSet(propfindUri);
    }

    protected String findAddressBookHomeSet(String propfindUri) throws IOException {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(CardDavPropertyName.ADDRESSBOOK_HOME_SET);
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        DavPropertySet props = this.getClient().propFind(propfindUri, principalsProps);
        return (String)props.get(CardDavPropertyName.ADDRESSBOOK_HOME_SET).getValue();
    }

    @Override
    public List<CardDavCollection> getCollections() throws ObjectStoreException, ObjectNotFoundException {
        try {
            String calHomeSetUri = this.findAddressBookHomeSet();
            if (calHomeSetUri == null) {
                throw new ObjectNotFoundException("No " + CardDavPropertyName.ADDRESSBOOK_HOME_SET + " attribute found for the user");
            }
            String urlForcalendarHomeSet = this.getHostURL() + calHomeSetUri;
            return this.getCollectionsForHomeSet(this, urlForcalendarHomeSet);
        }
        catch (IOException | ParserConfigurationException | DavException e) {
            throw new ObjectStoreException(e);
        }
    }

    protected List<CardDavCollection> getCollectionsForHomeSet(CardDavStore store, String urlForcalendarHomeSet) throws IOException, DavException {
        DavPropertyNameSet principalsProps = CardDavCollection.propertiesForFetch();
        return this.getClient().propFindResources(urlForcalendarHomeSet, principalsProps, ResourceType.ADRESSBOOK).entrySet().stream().map(e -> new CardDavCollection(this, (String)e.getKey(), (DavPropertySet)e.getValue())).collect(Collectors.toList());
    }

    public List<CardDavCollection> getDelegatedCollections() throws Exception {
        String methodUri = this.pathResolver.getPrincipalPath(this.getUserName());
        ExpandPropertyQuery expandPropertyWrite = new ExpandPropertyQuery(ExpandPropertyQuery.Type.PROXY_WRITE_FOR).withPropertyName(DavPropertyName.DISPLAYNAME).withPropertyName(SecurityConstants.PRINCIPAL_URL).withPropertyName(CalDavPropertyName.USER_ADDRESS_SET);
        ExpandPropertyQuery expandPropertyRead = new ExpandPropertyQuery(ExpandPropertyQuery.Type.PROXY_READ_FOR).withPropertyName(DavPropertyName.DISPLAYNAME).withPropertyName(SecurityConstants.PRINCIPAL_URL).withPropertyName(CalDavPropertyName.USER_ADDRESS_SET);
        ReportInfo rinfo = new ReportInfo(BaseDavPropertyName.EXPAND_PROPERTY, 0);
        rinfo.setContentElement(expandPropertyWrite.build());
        rinfo.setContentElement(expandPropertyRead.build());
        return this.getClient().report(methodUri, rinfo, new GetCardDavCollections());
    }

    @Override
    public CardDavCollection removeCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        CardDavCollection collection = this.getCollection(id);
        try {
            collection.delete();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to remove collection '%s'", id), e);
        }
        return collection;
    }

    final String getProdId() {
        return this.prodId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public CardDavCollection addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        throw new UnsupportedOperationException("not implemented");
    }
}

