/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.CalDavSupport;
import net.fortuna.ical4j.connector.dav.CardDavSupport;
import net.fortuna.ical4j.connector.dav.DavClientConfiguration;
import net.fortuna.ical4j.connector.dav.ResourceType;
import net.fortuna.ical4j.connector.dav.ScheduleResponse;
import net.fortuna.ical4j.connector.dav.SupportedFeature;
import net.fortuna.ical4j.connector.dav.method.FreeBusy;
import net.fortuna.ical4j.connector.dav.method.MkCalendar;
import net.fortuna.ical4j.connector.dav.method.PrincipalPropertySearch;
import net.fortuna.ical4j.connector.dav.method.PrincipalPropertySearchInfo;
import net.fortuna.ical4j.connector.dav.method.PutCalendar;
import net.fortuna.ical4j.connector.dav.method.PutVCard;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.request.CalendarQuery;
import net.fortuna.ical4j.connector.dav.response.GetCollections;
import net.fortuna.ical4j.connector.dav.response.GetFreeBusyData;
import net.fortuna.ical4j.connector.dav.response.GetPrincipals;
import net.fortuna.ical4j.connector.dav.response.GetResourceProperties;
import net.fortuna.ical4j.connector.dav.response.GetSupportedFeatures;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.vcard.VCard;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpCopy;
import org.apache.jackrabbit.webdav.client.methods.HttpDelete;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpProppatch;
import org.apache.jackrabbit.webdav.client.methods.HttpReport;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jooq.lambda.Unchecked;

public class DefaultDavClient
implements CalDavSupport,
CardDavSupport {
    private final HttpHost hostConfiguration;
    private final String repositoryPath;
    private final DavClientConfiguration clientConfiguration;
    protected HttpClient httpClient;
    protected HttpClientContext httpClientContext;
    private Header bearerAuth;

    DefaultDavClient(@NotNull String href, DavClientConfiguration clientConfiguration) throws MalformedURLException {
        this(URI.create(href).toURL(), clientConfiguration);
    }

    DefaultDavClient(@NotNull URL href, DavClientConfiguration clientConfiguration) {
        this.hostConfiguration = new HttpHost(href.getHost(), href.getPort(), href.getProtocol());
        this.repositoryPath = href.getPath();
        this.clientConfiguration = clientConfiguration;
    }

    void begin() {
        this.httpClient = HttpClients.createDefault();
    }

    public List<SupportedFeature> begin(String bearerAuth) throws IOException, FailedOperationException {
        this.bearerAuth = new BasicHeader("Authorization", "Bearer " + bearerAuth);
        return this.getSupportedFeatures();
    }

    public List<SupportedFeature> begin(String username, char[] password) throws IOException, FailedOperationException {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, new String(password));
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.hostConfiguration), (Credentials)credentials);
        this.begin((CredentialsProvider)credentialsProvider);
        return this.getSupportedFeatures();
    }

    void begin(CredentialsProvider credentialsProvider) {
        HttpClientBuilder builder = HttpClients.custom().setDefaultCredentialsProvider(credentialsProvider);
        if (this.clientConfiguration.isFollowRedirects()) {
            builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        this.httpClient = builder.build();
        this.httpClientContext = HttpClientContext.create();
        if (this.clientConfiguration.isPreemptiveAuth()) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this.hostConfiguration, (AuthScheme)new BasicScheme());
            this.httpClientContext.setAuthCache((AuthCache)authCache);
        }
    }

    public List<SupportedFeature> getSupportedFeatures() throws IOException, FailedOperationException {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(DavPropertyName.RESOURCETYPE);
        props.add(CSDavPropertyName.CTAG);
        DavPropertyName owner = DavPropertyName.create((String)"owner", (Namespace)DavConstants.NAMESPACE);
        props.add(owner);
        HttpPropfind aGet = new HttpPropfind(this.repositoryPath, 0, props, 0);
        if (this.bearerAuth != null) {
            aGet.addHeader(this.bearerAuth);
        }
        RequestConfig.Builder builder = aGet.getConfig() == null ? RequestConfig.custom() : RequestConfig.copy((RequestConfig)aGet.getConfig());
        builder.setAuthenticationEnabled(true);
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        builder.setTargetPreferredAuthSchemes(authPrefs);
        RequestConfig config = builder.build();
        aGet.setConfig(config);
        return this.execute((HttpRequest)aGet, new GetSupportedFeatures());
    }

    @Override
    public void mkCalendar(String path, DavPropertySet properties) throws IOException, ObjectStoreException, DavException {
        HttpResponse httpResponse;
        MkCalendar mkCalendarMethod = new MkCalendar(this.resolvePath(path), properties);
        if (!mkCalendarMethod.succeeded(httpResponse = this.execute(mkCalendarMethod))) {
            throw new ObjectStoreException(httpResponse.getStatusLine().getStatusCode() + ": " + httpResponse.getStatusLine().getReasonPhrase());
        }
    }

    @Override
    public void mkCol(String path) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public DavPropertySet propFind(String path, DavPropertyNameSet propertyNames) throws IOException {
        HttpPropfind aGet = new HttpPropfind(this.resolvePath(path), propertyNames, 0);
        return this.execute((HttpRequest)aGet, new GetResourceProperties());
    }

    public Map<String, DavPropertySet> propFindResources(String path, DavPropertyNameSet propertyNames, ResourceType ... resourceTypes) throws IOException {
        HttpPropfind aGet = new HttpPropfind(this.resolvePath(path), propertyNames, 0);
        return this.execute((HttpRequest)aGet, new GetCollections(resourceTypes));
    }

    @Override
    public DavPropertySet propFindType(String path, int type) throws IOException {
        HttpPropfind aGet = new HttpPropfind(this.resolvePath(path), type, 1);
        return this.execute((HttpRequest)aGet, new GetResourceProperties());
    }

    @Override
    public Map<String, DavPropertySet> report(String path, CalendarQuery query, ReportType reportType, DavPropertyNameSet propertyNames) throws IOException, ParserConfigurationException {
        ReportInfo info = new ReportInfo(reportType, 1, propertyNames);
        info.setContentElement(query.build());
        HttpReport method = new HttpReport(this.resolvePath(path), info);
        return this.execute((HttpRequest)method, new GetCollections(new ResourceType[0]));
    }

    @Override
    public <T> T report(String path, ReportInfo info, ResponseHandler<T> handler) throws IOException, ParserConfigurationException {
        HttpReport method = new HttpReport(this.resolvePath(path), info);
        return this.execute((HttpRequest)method, handler);
    }

    @Override
    public <T> T get(String path, ResponseHandler<T> handler) throws IOException {
        HttpGet httpGet = new HttpGet(this.resolvePath(path));
        return this.execute((HttpRequest)httpGet, handler);
    }

    @Override
    public <T> T head(String path, ResponseHandler<T> handler) throws IOException {
        HttpHead httpHead = new HttpHead(this.resolvePath(path));
        return this.execute((HttpRequest)httpHead, handler);
    }

    @Override
    public void put(String path, Calendar calendar, String etag) throws IOException, FailedOperationException {
        PutCalendar httpPut = new PutCalendar(this.resolvePath(path));
        httpPut.setEtag(etag);
        httpPut.setCalendar(calendar);
        HttpResponse httpResponse = this.execute((HttpRequest)httpPut);
        if (!httpPut.succeeded(httpResponse)) {
            throw new FailedOperationException("Error creating calendar on server: " + httpResponse.getStatusLine());
        }
    }

    @Override
    public void put(String path, VCard card, String etag) throws IOException, FailedOperationException {
        PutVCard httpPut = new PutVCard(this.resolvePath(path));
        httpPut.setEtag(etag);
        httpPut.setVCard(card);
        HttpResponse httpResponse = this.execute((HttpRequest)httpPut);
        if (!httpPut.succeeded(httpResponse)) {
            throw new FailedOperationException("Error creating card on server: " + httpResponse.getStatusLine());
        }
    }

    @Override
    public void copy(String src, String dest) throws DavException, IOException {
        HttpCopy method = new HttpCopy(this.resolvePath(src), this.resolvePath(dest), true, false);
        this.execute((HttpRequest)method, response -> {
            try {
                method.checkSuccess(response);
            }
            catch (DavException e) {
                Unchecked.throwChecked((Throwable)e);
            }
            return true;
        });
    }

    @Override
    public void move(String src, String dest) throws IOException, DavException {
        HttpMove method = new HttpMove(this.resolvePath(src), this.resolvePath(dest), true);
        this.execute((HttpRequest)method, response -> {
            try {
                method.checkSuccess(response);
            }
            catch (DavException e) {
                Unchecked.throwChecked((Throwable)e);
            }
            return true;
        });
    }

    @Override
    public void delete(String path) throws IOException, DavException {
        HttpDelete method = new HttpDelete(this.resolvePath(path));
        this.execute((HttpRequest)method, response -> {
            try {
                method.checkSuccess(response);
            }
            catch (DavException e) {
                Unchecked.throwChecked((Throwable)e);
            }
            return true;
        });
    }

    public List<ScheduleResponse> freeBusy(String path, Calendar query, Organizer organizer) throws IOException {
        FreeBusy freeBusy = new FreeBusy(this.resolvePath(path), organizer);
        freeBusy.setQuery(query);
        return this.execute((HttpRequest)freeBusy, new GetFreeBusyData());
    }

    @Override
    public MultiStatusResponse propPatch(String path, List<? extends PropEntry> changeList) throws IOException {
        HttpProppatch method = new HttpProppatch(this.resolvePath(path), changeList);
        return (MultiStatusResponse)this.execute((HttpRequest)method, response -> {
            try {
                method.checkSuccess(response);
                return method.getResponseBodyAsMultiStatus(response).getResponses()[0];
            }
            catch (DavException e) {
                Unchecked.throwChecked((Throwable)e);
                return null;
            }
        });
    }

    @Override
    public void post() {
    }

    @Override
    public void lock(String path) {
    }

    @Override
    public void unlock(String path) {
    }

    public List<Attendee> findPrincipals(String path, PrincipalPropertySearchInfo info) throws IOException {
        PrincipalPropertySearch principalPropertySearch = new PrincipalPropertySearch(this.resolvePath(path), info);
        return this.execute((HttpRequest)principalPropertySearch, new GetPrincipals());
    }

    private String resolvePath(String path) {
        if (path == null) {
            return this.repositoryPath;
        }
        if (path.startsWith("/")) {
            return this.repositoryPath + path.substring(1);
        }
        return this.repositoryPath + path;
    }

    private HttpResponse execute(BaseDavRequest method) throws IOException, DavException {
        HttpResponse response = this.httpClient.execute(this.hostConfiguration, (HttpRequest)method, (HttpContext)this.httpClientContext);
        method.checkSuccess(response);
        return response;
    }

    private HttpResponse execute(HttpRequest method) throws IOException {
        return this.httpClient.execute(this.hostConfiguration, method, (HttpContext)this.httpClientContext);
    }

    private <T> T execute(HttpRequest method, ResponseHandler<T> handler) throws IOException {
        return (T)this.httpClient.execute(this.hostConfiguration, method, handler, (HttpContext)this.httpClientContext);
    }
}

