/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface PathResolver {
    public String getRootPath();

    public String getPrincipalPath(String var1);

    public String getRepositoryRoot(String var1, String var2);

    public String getResourcePath(String var1, String var2);

    public static enum Defaults implements PathResolver
    {
        CHANDLER("/dav", "/%s/", "/users/%s", "/users/(\\w+)/?"),
        RADICALE("", "/", "/%s", "/([\\w]+)/?"),
        BAIKAL("/dav.php", "/", "/calendars/%s", "/calendars/([\\w]+)/?"),
        CGP("/CalDAV", "/", "/", "/(\\w+)/?"),
        KMS("/caldav", "/", "/", "/(\\w+)/?"),
        ZIMBRA("", "/principals/users/%s/", "/dav/%s/", "/(\\w+)/?"),
        ICAL_SERVER("", "/principals/users/%s/", "/dav/%s/", "/(\\w+)/?"),
        CALENDAR_SERVER("/dav", "/%s/", "/%s", "/(\\w+)/?"),
        GCAL("/caldav/v2", "/%s/user", "/%s/events", "/\\w+/events/?"),
        SOGO("/dav", "/%s/", "/%s/", "/(\\w+)/?"),
        DAVICAL("/caldav.php", "/%s/", "/%s/", "/(\\w+)/?"),
        BEDEWORK("/ucaldav", "/principals/users/%s/", "/users/%s", "/users/(\\w+)/?"),
        ORACLE_CS("/dav", "/principals/%s/", "/home/%s/", "/home/(\\w+)/?"),
        GENERIC("", "/%s", "/%s", "/(\\w+)");

        private final String rootPath;
        private final String principalPathBase;
        private final String calendarPathBase;
        private final Pattern calendarPathPattern;

        private Defaults(String rootPath, String principalPathBase, String calendarPathBase, String calendarPathPattern) {
            this.rootPath = rootPath;
            this.principalPathBase = principalPathBase;
            this.calendarPathBase = calendarPathBase;
            this.calendarPathPattern = Pattern.compile("^" + rootPath + calendarPathPattern + "$");
        }

        @Override
        public String getRootPath() {
            return this.rootPath;
        }

        @Override
        public String getRepositoryRoot(String resourcePath, String wspPath) {
            if (wspPath != null && !wspPath.isEmpty()) {
                return this.rootPath + String.format("%s/%s", wspPath, String.format(this.calendarPathBase, resourcePath));
            }
            return this.rootPath + String.format(this.calendarPathBase, resourcePath);
        }

        @Override
        public String getResourcePath(String repositoryPath, String wspPath) {
            Matcher matcher = this.calendarPathPattern.matcher(repositoryPath);
            if (matcher.matches() && matcher.groupCount() > 0) {
                if (wspPath != null && !wspPath.isEmpty()) {
                    return String.format("%s/%s", wspPath, matcher.group(1));
                }
                return matcher.group(1);
            }
            return null;
        }

        @Override
        public String getPrincipalPath(String calendarId) {
            return this.rootPath + String.format(this.principalPathBase, calendarId);
        }
    }
}

