/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import org.apache.jackrabbit.webdav.DavConstants;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ScheduleResponse {
    private String recipient;
    private float requestStatusCode;
    private String requestStatusMessage;
    private Calendar calendarData;

    public ScheduleResponse(Element responseNode) throws IOException, ParserException {
        Element node;
        int nodesIndex;
        NodeList recipients = responseNode.getElementsByTagNameNS(CalDavPropertyName.NAMESPACE.getURI(), CalDavPropertyName.RECIPIENT.getName());
        NodeList status = responseNode.getElementsByTagNameNS(CalDavPropertyName.NAMESPACE.getURI(), CalDavPropertyName.REQUEST_STATUS.getName());
        NodeList calendars = responseNode.getElementsByTagNameNS(CalDavPropertyName.NAMESPACE.getURI(), CalDavPropertyName.CALENDAR_DATA.getName());
        for (nodesIndex = 0; nodesIndex < calendars.getLength(); ++nodesIndex) {
            node = (Element)calendars.item(nodesIndex);
            if (node.getFirstChild() == null) continue;
            CalendarBuilder builder = new CalendarBuilder();
            if (node.getFirstChild() instanceof CDATASection) {
                CDATASection calData = (CDATASection)node.getFirstChild();
                StringReader sin = new StringReader(calData.getData());
                this.calendarData = builder.build((Reader)sin);
            }
            if (!(node.getFirstChild() instanceof Text)) continue;
            StringReader sin = new StringReader(((Text)node.getFirstChild()).getTextContent());
            this.calendarData = builder.build((Reader)sin);
        }
        for (nodesIndex = 0; nodesIndex < status.getLength(); ++nodesIndex) {
            node = (Element)status.item(nodesIndex);
            String fullStatus = ((Text)node.getFirstChild()).getTextContent();
            String[] split = fullStatus.split(";");
            if (split.length != 2) continue;
            this.requestStatusCode = new Float(split[0]).floatValue();
            this.requestStatusMessage = split[1];
        }
        for (nodesIndex = 0; nodesIndex < recipients.getLength(); ++nodesIndex) {
            node = (Element)recipients.item(nodesIndex);
            NodeList childs = node.getElementsByTagNameNS(DavConstants.NAMESPACE.getURI(), "href");
            if (childs == null || childs.item(0) == null || childs.item(0).getFirstChild() == null) continue;
            this.recipient = childs.item(0).getFirstChild().getTextContent();
        }
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public float getRequestStatusCode() {
        return this.requestStatusCode;
    }

    public void setRequestStatusCode(float requestStatusCode) {
        this.requestStatusCode = requestStatusCode;
    }

    public String getRequestStatusMessage() {
        return this.requestStatusMessage;
    }

    public void setRequestStatusMessage(String requestStatusMessage) {
        this.requestStatusMessage = requestStatusMessage;
    }

    public Calendar getCalendarData() {
        return this.calendarData;
    }

    public void setCalendarData(Calendar calendarData) {
        this.calendarData = calendarData;
    }

    public boolean isSuccess() {
        return (double)this.requestStatusCode < 3.0;
    }
}

