/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.property;

import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;

public class DavPropertyBuilder<T> {
    private static final List<DavPropertyName> hrefProps = Arrays.asList(SecurityConstants.PRINCIPAL_COLLECTION_SET);
    private DavPropertyName name;
    private T value;

    public DavPropertyBuilder<T> name(DavPropertyName name) {
        this.name = name;
        return this;
    }

    public DavPropertyBuilder<T> value(T value) {
        this.value = value;
        return this;
    }

    public DavProperty<T> build() {
        if (hrefProps.contains(this.name)) {
            return new HrefProperty(this.name, (String[])this.value, false);
        }
        return new DefaultDavProperty(this.name, this.value);
    }
}

