/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.request;

import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.request.XmlSupport;
import net.fortuna.ical4j.model.DateTime;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventQuery
extends ReportInfo
implements XmlSupport {
    private DateTime startTime;
    private DateTime endTime;

    public EventQuery(int depth) {
        super(CalDavPropertyName.CALENDAR_QUERY, depth);
    }

    public EventQuery withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public EventQuery withEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Element toXml(Document document) {
        Element calData = this.newElement(document, CalDavPropertyName.CALENDAR_DATA, new Node[0]);
        Element calFilter = this.newComponentFilter(document, "VCALENDAR", new Node[]{this.newComponentFilter(document, "VEVENT", new Node[]{this.newTimeRange(document, this.startTime.toString(), this.endTime.toString())})});
        Element property = this.newElement(document, BaseDavPropertyName.PROP, new Node[]{this.newCalDavElement(document, "getetag", new Node[0]), document.importNode(calData, true)});
        document.appendChild(property);
        this.setContentElement(property);
        Element parentFilter = this.newCalDavElement(document, "filter", new Node[0]);
        this.setContentElement(parentFilter);
        Node importedFilter = document.importNode(calFilter, true);
        parentFilter.appendChild(importedFilter);
        DavPropertyNameSet propertyNames = new DavPropertyNameSet();
        propertyNames.add(DavPropertyName.create((String)"prop", (Namespace)CalDavPropertyName.NAMESPACE));
        propertyNames.add(DavPropertyName.GETETAG);
        return super.toXml(document);
    }
}

