/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.request;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.request.XmlSupport;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExpandPropertyQuery
implements XmlSupport,
XmlSerializable {
    private final Type type;
    private final List<DavPropertyName> propertyNames;

    public ExpandPropertyQuery(Type type) {
        this.type = type;
        this.propertyNames = new ArrayList<DavPropertyName>();
    }

    public ExpandPropertyQuery withPropertyName(DavPropertyName propertyName) {
        this.propertyNames.add(propertyName);
        return this;
    }

    public Element build() throws ParserConfigurationException {
        Document document = this.newXmlDocument(new Node[0]);
        return this.toXml(document);
    }

    public Element toXml(Document document) {
        Element propertyElement = this.type.getPropertyName().toXml(document);
        this.propertyNames.stream().map(p -> p.toXml(document)).forEach(propertyElement::appendChild);
        return propertyElement;
    }

    public static enum Type {
        PROXY_READ_FOR(CSDavPropertyName.PROXY_READ_FOR),
        PROXY_WRITE_FOR(CSDavPropertyName.PROXY_WRITE_FOR);

        private final DavPropertyName propertyName;

        private Type(DavPropertyName propertyName) {
            this.propertyName = propertyName;
        }

        public DavPropertyName getPropertyName() {
            return this.propertyName;
        }
    }
}

