/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.request;

import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.request.XmlSupport;
import net.fortuna.ical4j.model.parameter.CuType;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PrincipalPropertySearch
implements XmlSupport,
XmlSerializable {
    private final CuType type;
    private final String nameToSearch;

    public PrincipalPropertySearch(CuType type) {
        this(type, null);
    }

    public PrincipalPropertySearch(CuType type, String nameToSearch) {
        this.type = type;
        this.nameToSearch = nameToSearch;
    }

    protected Element propertiesForPropSearch(Document document) {
        Element firstNameProperty = this.newCsElement(document, "first-name", new Node[0]);
        Element recordTypeProperty = this.newCsElement(document, "record-type", new Node[0]);
        Element calUserAddressSetProperty = this.newElement(document, CalDavPropertyName.USER_ADDRESS_SET, new Node[0]);
        Element lastNameProperty = this.newCsElement(document, "last-name", new Node[0]);
        Element principalUrlProperty = this.newElement(document, SecurityConstants.PRINCIPAL_URL, new Node[0]);
        Element calUserTypeProperty = this.newElement(document, CalDavPropertyName.USER_TYPE, new Node[0]);
        Element displayNameForProperty = this.newElement(document, DavPropertyName.DISPLAYNAME, new Node[0]);
        Element emailAddressSetProperty = this.newCsElement(document, "email-address-set", new Node[0]);
        return this.newElement(document, BaseDavPropertyName.PROP, firstNameProperty, recordTypeProperty, calUserAddressSetProperty, lastNameProperty, principalUrlProperty, calUserTypeProperty, displayNameForProperty, emailAddressSetProperty);
    }

    public Element build() throws ParserConfigurationException {
        Document document = this.newXmlDocument(new Node[0]);
        return this.toXml(document);
    }

    public Element toXml(Document document) {
        Element displayName = this.nameToSearch != null ? this.newElement(document, DavPropertyName.DISPLAYNAME, new Node[0]) : this.newCalDavElement(document, "calendar-user-type", new Node[0]);
        Element displayNameProperty = this.newElement(document, BaseDavPropertyName.PROP, displayName);
        Element containsMatch = this.newDavElement(document, "match", new Node[0]);
        if (this.nameToSearch != null) {
            containsMatch.setAttribute("match-type", "contains");
            containsMatch.setTextContent(this.nameToSearch);
        } else {
            containsMatch.setAttribute("match-type", "equals");
            containsMatch.setTextContent(this.type.getValue());
        }
        Element propertySearchDisplayName = this.newDavElement(document, "property-search", displayNameProperty, containsMatch);
        Element properties = this.propertiesForPropSearch(document);
        Element principalPropSearch = this.newDavElement(document, "principal-property-search", new Node[0]);
        principalPropSearch.setAttribute("type", this.type.getValue());
        principalPropSearch.setAttribute("test", "anyof");
        principalPropSearch.appendChild(propertySearchDisplayName);
        if (this.nameToSearch != null) {
            Element emailAddressSet = this.newCsElement(document, "email-address-set", new Node[0]);
            Element emailSetProperty = this.newElement(document, BaseDavPropertyName.PROP, emailAddressSet);
            Element startsWith = this.newDavElement(document, "match", new Node[0]);
            startsWith.setAttribute("match-type", "starts-with");
            if (startsWith != null) {
                startsWith.setTextContent(this.nameToSearch);
            }
            Element propertySearchEmail = this.newDavElement(document, "property-search", new Node[0]);
            propertySearchEmail.setTextContent(this.nameToSearch);
            propertySearchEmail.appendChild(emailSetProperty);
            propertySearchEmail.appendChild(startsWith);
            principalPropSearch.appendChild(propertySearchEmail);
        }
        principalPropSearch.appendChild(properties);
        return principalPropSearch;
    }
}

