/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.request;

import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public interface XmlSupport {
    public static final String PROPERTY_COMP_FILTER = "comp-filter";
    public static final String PROPERTY_TIME_RANGE = "time-range";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_START = "start";
    public static final String ATTRIBUTE_END = "end";

    default public Document newXmlDocument(Node ... children) throws ParserConfigurationException {
        Document document = DomUtil.createDocument();
        Arrays.stream(children).forEach(document::appendChild);
        return document;
    }

    default public Element newElement(Document document, String elementName, Namespace namespace, Node ... children) {
        Element element = DomUtil.createElement((Document)document, (String)elementName, (Namespace)namespace);
        Arrays.stream(children).forEach(element::appendChild);
        return element;
    }

    default public Element newElement(Document document, DavPropertyName propertyName, Node ... children) {
        Element element = DomUtil.createElement((Document)document, (String)propertyName.getName(), (Namespace)propertyName.getNamespace());
        Arrays.stream(children).forEach(element::appendChild);
        return element;
    }

    @Deprecated
    default public Element newDavElement(Document document, String elementName, Node ... children) {
        return this.newElement(document, elementName, DavConstants.NAMESPACE, children);
    }

    @Deprecated
    default public Element newCsElement(Document document, String elementName, Node ... children) {
        return this.newElement(document, elementName, CSDavPropertyName.NAMESPACE, children);
    }

    @Deprecated
    default public Element newCalDavElement(Document document, String elementName, Node ... children) {
        return this.newElement(document, elementName, CalDavPropertyName.NAMESPACE, children);
    }

    default public Element newComponentFilter(Document document, String componentName, Node ... children) {
        Element calFilter = this.newCalDavElement(document, PROPERTY_COMP_FILTER, new Node[0]);
        calFilter.setAttribute(ATTRIBUTE_NAME, componentName);
        Arrays.stream(children).forEach(calFilter::appendChild);
        return calFilter;
    }

    default public Element newTimeRange(Document document, String startTime, String endTime) {
        Element timeRange = this.newCalDavElement(document, PROPERTY_TIME_RANGE, new Node[0]);
        timeRange.setAttribute(ATTRIBUTE_START, startTime);
        timeRange.setAttribute(ATTRIBUTE_END, endTime);
        return timeRange;
    }
}

