/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fortuna.ical4j.connector.MediaType;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    protected InputStream getContent(HttpResponse response, MediaType mediaType) throws IOException {
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null && httpEntity.getContentType().getValue().startsWith(mediaType.getContentType())) {
            return httpEntity.getContent();
        }
        return null;
    }

    protected <R> List<R> getHeaders(HttpResponse response, String name, Function<Header, R> mapper) {
        return Arrays.stream(response.getHeaders(name)).map(mapper).collect(Collectors.toList());
    }

    protected <R> List<R> getHeaderElements(HttpResponse response, String name, Function<HeaderElement, R> mapper) {
        return Arrays.stream(response.getHeaders(name)).flatMap(h -> Arrays.stream(h.getElements())).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Document getResponseBodyAsDocument(HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        try (InputStream in = entity.getContent();){
            Document document = DomUtil.parseDocument((InputStream)in);
            return document;
        }
    }

    private MultiStatus getResponseBodyAsMultiStatus(HttpResponse response) throws DavException {
        try {
            Document doc = this.getResponseBodyAsDocument(response.getEntity());
            if (doc == null) {
                throw new DavException(response.getStatusLine().getStatusCode(), "no response body");
            }
            return MultiStatus.createFromXml((Element)doc.getDocumentElement());
        }
        catch (IOException ex) {
            throw new DavException(response.getStatusLine().getStatusCode(), (Throwable)ex);
        }
    }

    protected MultiStatus getMultiStatus(HttpResponse response) throws DavException {
        if (response.getStatusLine().getStatusCode() != 207) {
            throw new RuntimeException("Unexpected status code");
        }
        return this.getResponseBodyAsMultiStatus(response);
    }
}

