/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.dav.CardDavCollection;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.response.AbstractResponseHandler;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetCardDavCollections
extends AbstractResponseHandler<List<CardDavCollection>> {
    public List<CardDavCollection> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        ArrayList<CardDavCollection> collections = new ArrayList<CardDavCollection>();
        try {
            MultiStatusResponse[] responses;
            MultiStatus multiStatus = this.getMultiStatus(response);
            for (MultiStatusResponse msr : responses = multiStatus.getResponses()) {
                DavPropertySet properties = msr.getProperties(200);
                DavProperty writeForProperty = properties.get("calendar-proxy-write-for", CSDavPropertyName.NAMESPACE);
                collections.addAll(this.getDelegateCollections(writeForProperty));
                DavProperty readForProperty = properties.get("calendar-proxy-read-for", CSDavPropertyName.NAMESPACE);
                collections.addAll(this.getDelegateCollections(readForProperty));
            }
        }
        catch (ParserConfigurationException | DavException e) {
            throw new RuntimeException(e);
        }
        return collections;
    }

    protected List<CardDavCollection> getDelegateCollections(DavProperty<?> proxyDavProperty) throws ParserConfigurationException, IOException, DavException {
        if (proxyDavProperty != null) {
            Object propertyValue = proxyDavProperty.getValue();
            if (propertyValue instanceof List) {
                List response = (List)proxyDavProperty.getValue();
                if (response != null) {
                    for (Node objectInArray : response) {
                        DefaultDavProperty newProperty;
                        if (!(objectInArray instanceof Element) || !(newProperty = DefaultDavProperty.createFromXml((Element)((Element)objectInArray))).getName().getName().equals("response") || !newProperty.getName().getNamespace().equals((Object)DavConstants.NAMESPACE)) continue;
                        List responseChilds = (List)newProperty.getValue();
                        for (Node responseChild : responseChilds) {
                            DefaultDavProperty responseChildElement;
                            if (!(responseChild instanceof Element) || !(responseChildElement = DefaultDavProperty.createFromXml((Element)((Element)responseChild))).getName().getName().equals("propstat")) continue;
                            List propStatChilds = (List)responseChildElement.getValue();
                            for (Node propStatChild : propStatChilds) {
                                DefaultDavProperty propStatChildElement;
                                if (!(propStatChild instanceof Element) || !(propStatChildElement = DefaultDavProperty.createFromXml((Element)((Element)propStatChild))).getName().getName().equals("prop")) continue;
                                List propChilds = (List)propStatChildElement.getValue();
                                for (Node propChild : propChilds) {
                                    DefaultDavProperty propChildElement;
                                    if (!(propChild instanceof Element) || !(propChildElement = DefaultDavProperty.createFromXml((Element)((Element)propChild))).getName().equals((Object)SecurityConstants.PRINCIPAL_URL)) continue;
                                    List principalUrlChilds = (List)propChildElement.getValue();
                                    for (Node principalUrlChild : principalUrlChilds) {
                                        DefaultDavProperty principalUrlElement;
                                        if (!(principalUrlChild instanceof Element) || !(principalUrlElement = DefaultDavProperty.createFromXml((Element)((Element)principalUrlChild))).getName().getName().equals("href")) continue;
                                        String string = (String)principalUrlElement.getValue();
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (propertyValue instanceof Element) {
                System.out.println(((Element)propertyValue).getNodeName());
                System.out.println(((Element)propertyValue).getChildNodes());
            }
        }
        return new ArrayList<CardDavCollection>();
    }
}

