/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.response;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fortuna.ical4j.connector.dav.ResourceType;
import net.fortuna.ical4j.connector.dav.response.AbstractResponseHandler;
import org.apache.http.HttpResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

public class GetCollections
extends AbstractResponseHandler<Map<String, DavPropertySet>> {
    private final List<String> resourceTypes;

    public GetCollections(ResourceType ... type) {
        this.resourceTypes = Arrays.stream(type).map(ResourceType::description).collect(Collectors.toList());
    }

    public Map<String, DavPropertySet> handleResponse(HttpResponse response) {
        try {
            MultiStatus multiStatus = this.getMultiStatus(response);
            return Arrays.stream(multiStatus.getResponses()).filter(msr -> this.resourceTypes.contains((String)msr.getProperties(200).get(DavPropertyName.RESOURCETYPE).getValue())).collect(Collectors.toMap(MultiStatusResponse::getHref, msr -> msr.getProperties(200)));
        }
        catch (DavException e) {
            throw new RuntimeException(e);
        }
    }
}

