/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.response;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.response.AbstractResponseHandler;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.property.Attendee;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.w3c.dom.Node;

public class GetPrincipals
extends AbstractResponseHandler<List<Attendee>> {
    public List<Attendee> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        ArrayList<Attendee> resources = new ArrayList<Attendee>();
        try {
            MultiStatusResponse[] responses;
            MultiStatus multiStatus = this.getMultiStatus(response);
            for (MultiStatusResponse msr : responses = multiStatus.getResponses()) {
                DavProperty calendarUserType;
                URI calAddressUri;
                Attendee resource = new Attendee();
                DavPropertySet propertiesInResponse = msr.getProperties(200);
                DavProperty displayNameFromResponse = propertiesInResponse.get("displayname", DavConstants.NAMESPACE);
                if (displayNameFromResponse != null && displayNameFromResponse.getValue() != null) {
                    resource.getParameters().add((Parameter)new Cn((String)displayNameFromResponse.getValue()));
                }
                if ((calAddressUri = this.getCalAddress(propertiesInResponse)) != null) {
                    resource.setCalAddress(calAddressUri);
                }
                if ((calendarUserType = propertiesInResponse.get(CalDavPropertyName.USER_TYPE)) != null && calendarUserType.getValue() != null) {
                    resource.getParameters().add((Parameter)new CuType((String)calendarUserType.getValue()));
                }
                resources.add(resource);
            }
        }
        catch (DavException e) {
            throw new RuntimeException(e);
        }
        return resources;
    }

    private URI getCalAddress(DavPropertySet propertiesInResponse) {
        block5: {
            Object value;
            block4: {
                DavProperty emailSet = propertiesInResponse.get("email-address-set", CSDavPropertyName.NAMESPACE);
                if (emailSet == null || emailSet.getValue() == null) break block4;
                Object emailSetValue = emailSet.getValue();
                if (!(emailSetValue instanceof List)) break block5;
                for (Object email : (List)emailSetValue) {
                    String emailAddress;
                    if (!(email instanceof Node) || (emailAddress = ((Node)email).getTextContent()) == null || emailAddress.trim().length() <= 0) continue;
                    if (!emailAddress.startsWith("mailto:")) {
                        emailAddress = "mailto:".concat(emailAddress);
                    }
                    return URI.create(emailAddress);
                }
                break block5;
            }
            DavProperty calendarUserAddressSet = propertiesInResponse.get("calendar-user-address-set", CalDavPropertyName.NAMESPACE);
            if (calendarUserAddressSet != null && calendarUserAddressSet.getValue() != null && (value = calendarUserAddressSet.getValue()) instanceof List) {
                for (Object addressSet : (List)value) {
                    String url;
                    if (!(addressSet instanceof Node) || !(url = ((Node)addressSet).getTextContent()).startsWith("urn:uuid")) continue;
                    return URI.create(url);
                }
            }
        }
        return null;
    }
}

